/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.utils.SourceDestValidations;

public class TransportPreviewTransformAction
extends HandledTransportAction<PreviewTransformAction.Request, PreviewTransformAction.Response> {
    private static final int NUMBER_OF_PREVIEW_BUCKETS = 100;
    private final XPackLicenseState licenseState;
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final SourceDestValidator sourceDestValidator;

    @Inject
    public TransportPreviewTransformAction(TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, IngestService ingestService) {
        this("cluster:admin/transform/preview", transportService, actionFilters, client, threadPool, licenseState, indexNameExpressionResolver, clusterService, settings, ingestService);
    }

    protected TransportPreviewTransformAction(String name, TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, IngestService ingestService) {
        super(name, transportService, actionFilters, PreviewTransformAction.Request::new);
        this.licenseState = licenseState;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), DiscoveryNode.isRemoteClusterClient((Settings)settings) ? new RemoteClusterLicenseChecker(client, XPackLicenseState::isTransformAllowedForOperationMode) : null, ingestService, clusterService.getNodeName(), License.OperationMode.BASIC.description());
    }

    protected void doExecute(Task task, PreviewTransformAction.Request request, ActionListener<PreviewTransformAction.Response> listener) {
        if (!this.licenseState.checkFeature(XPackLicenseState.Feature.TRANSFORM)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"transform"));
            return;
        }
        ClusterState clusterState = this.clusterService.state();
        TransformConfig config = request.getConfig();
        this.sourceDestValidator.validate(clusterState, config.getSource().getIndex(), config.getDestination().getIndex(), config.getDestination().getPipeline(), SourceDestValidations.PREVIEW_VALIDATIONS, ActionListener.wrap(r -> {
            Function function = FunctionFactory.create(config);
            function.validateConfig((ActionListener<Boolean>)ActionListener.wrap(functionValidationResponse -> this.getPreview(config.getId(), function, config.getSource(), config.getDestination().getPipeline(), config.getDestination().getIndex(), listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getPreview(String transformId, Function function, SourceConfig source, String pipeline, String dest, ActionListener<PreviewTransformAction.Response> listener) {
        SetOnce mappings = new SetOnce();
        ActionListener pipelineResponseActionListener = ActionListener.wrap(simulatePipelineResponse -> {
            ArrayList<Map> docs = new ArrayList<Map>(simulatePipelineResponse.getResults().size());
            for (SimulateDocumentResult simulateDocumentResult : simulatePipelineResponse.getResults()) {
                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                try {
                    XContentBuilder content = simulateDocumentResult.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                    Map tempMap = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)content), (boolean)true, (XContentType)XContentType.JSON).v2();
                    docs.add((Map)XContentMapValues.extractValue((String)"doc._source", (Map)tempMap));
                }
                finally {
                    if (xContentBuilder == null) continue;
                    xContentBuilder.close();
                }
            }
            TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings((Map)mappings.get(), transformId, Clock.systemUTC());
            listener.onResponse((Object)new PreviewTransformAction.Response(docs, generatedDestIndexSettings));
        }, arg_0 -> listener.onFailure(arg_0));
        function.deduceMappings(this.client, source, (ActionListener<Map<String, String>>)ActionListener.wrap(deducedMappings -> {
            mappings.set(deducedMappings);
            function.preview(this.client, ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders()), source, (Map<String, String>)deducedMappings, 100, (ActionListener<List<Map<String, Object>>>)ActionListener.wrap(docs -> {
                if (pipeline == null) {
                    TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings((Map)mappings.get(), transformId, Clock.systemUTC());
                    listener.onResponse((Object)new PreviewTransformAction.Response(docs, generatedDestIndexSettings));
                } else {
                    List results = docs.stream().map(doc -> {
                        HashMap<String, Object> src = new HashMap<String, Object>();
                        String id = (String)doc.get(TransformField.DOCUMENT_ID_FIELD);
                        src.put("_source", doc);
                        src.put("_id", id);
                        src.put("_index", dest);
                        return src;
                    }).collect(Collectors.toList());
                    try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                        builder.startObject();
                        builder.field("docs", results);
                        builder.endObject();
                        SimulatePipelineRequest pipelineRequest = new SimulatePipelineRequest(BytesReference.bytes((XContentBuilder)builder), XContentType.JSON);
                        pipelineRequest.setId(pipeline);
                        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)SimulatePipelineAction.INSTANCE, (ActionRequest)pipelineRequest, (ActionListener)pipelineResponseActionListener);
                    }
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

