/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

public class TransportDeleteTransformAction
extends TransportMasterNodeAction<DeleteTransformAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor auditor;
    private final Client client;

    @Inject
    public TransportDeleteTransformAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, Client client) {
        this("cluster:admin/transform/delete", transportService, actionFilters, threadPool, clusterService, indexNameExpressionResolver, transformServices, client);
    }

    protected TransportDeleteTransformAction(String name, TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, Client client) {
        super(name, transportService, clusterService, threadPool, actionFilters, DeleteTransformAction.Request::new, indexNameExpressionResolver);
        this.transformConfigManager = transformServices.getConfigManager();
        this.auditor = transformServices.getAuditor();
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(DeleteTransformAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetadata pTasksMeta = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        if (pTasksMeta != null && pTasksMeta.getTask(request.getId()) != null && !request.isForce()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete transform [" + request.getId() + "] as the task is running. Stop the task first", RestStatus.CONFLICT, new Object[0]));
        } else {
            ActionListener stopTransformActionListener = ActionListener.wrap(stopResponse -> this.transformConfigManager.deleteTransform(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                logger.debug("[{}] deleted transform", (Object)request.getId());
                this.auditor.info(request.getId(), "Deleted transform.");
                listener.onResponse((Object)new AcknowledgedResponse(r.booleanValue()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
            if (pTasksMeta != null && pTasksMeta.getTask(request.getId()) != null) {
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)StopTransformAction.INSTANCE, (ActionRequest)new StopTransformAction.Request(request.getId(), true, true, null, true, false), (ActionListener)ActionListener.wrap(r -> stopTransformActionListener.onResponse(null), arg_0 -> ((ActionListener)stopTransformActionListener).onFailure(arg_0)));
            } else {
                stopTransformActionListener.onResponse(null);
            }
        }
    }

    protected ClusterBlockException checkBlock(DeleteTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

