/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.frozen.rest.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.protocol.xpack.frozen.FreezeRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public final class RestFreezeIndexAction
extends XPackRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_freeze"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_unfreeze")));
    }

    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) {
        boolean freeze = request.path().endsWith("/_freeze");
        FreezeRequest freezeRequest = new FreezeRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        freezeRequest.timeout(request.paramAsTime("timeout", freezeRequest.timeout()));
        freezeRequest.masterNodeTimeout(request.paramAsTime("master_timeout", freezeRequest.masterNodeTimeout()));
        freezeRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)freezeRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            freezeRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        freezeRequest.setFreeze(freeze);
        return channel -> client.freeze(freezeRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "freeze_index";
    }
}

