/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.search.AsyncSearchTask;

class MutableSearchResponse {
    private final int totalShards;
    private final int skippedShards;
    private final SearchResponse.Clusters clusters;
    private final AtomicArray<ShardSearchFailure> queryFailures;
    private final ThreadContext threadContext;
    private boolean isPartial;
    private int successfulShards;
    private TotalHits totalHits;
    private Supplier<InternalAggregations> reducedAggsSource = () -> null;
    private int reducePhase;
    private SearchResponse finalResponse;
    private ElasticsearchException failure;
    private Map<String, List<String>> responseHeaders;
    private boolean frozen;

    MutableSearchResponse(int totalShards, int skippedShards, SearchResponse.Clusters clusters, ThreadContext threadContext) {
        this.totalShards = totalShards;
        this.skippedShards = skippedShards;
        this.clusters = clusters;
        this.queryFailures = totalShards == -1 ? null : new AtomicArray(totalShards - skippedShards);
        this.isPartial = true;
        this.threadContext = threadContext;
        this.totalHits = new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
    }

    synchronized void updatePartialResponse(int successfulShards, TotalHits totalHits, Supplier<InternalAggregations> reducedAggs, int reducePhase) {
        this.failIfFrozen();
        if (reducePhase < this.reducePhase) {
            throw new IllegalStateException("received partial response out of order: " + reducePhase + " < " + this.reducePhase);
        }
        this.successfulShards = successfulShards + this.skippedShards;
        this.totalHits = totalHits;
        this.reducedAggsSource = reducedAggs;
        this.reducePhase = reducePhase;
    }

    synchronized void updateFinalResponse(SearchResponse response) {
        this.failIfFrozen();
        assert (response.getTotalShards() == this.totalShards) : "received number of total shards differs from the one notified through onListShards";
        assert (response.getSkippedShards() == this.skippedShards) : "received number of skipped shards differs from the one notified through onListShards";
        this.responseHeaders = this.threadContext.getResponseHeaders();
        this.finalResponse = response;
        this.isPartial = false;
        this.frozen = true;
    }

    synchronized void updateWithFailure(ElasticsearchException exc) {
        this.failIfFrozen();
        this.responseHeaders = this.threadContext.getResponseHeaders();
        this.isPartial = true;
        this.failure = exc;
        this.frozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueryFailure(int shardIndex, ShardSearchFailure failure) {
        MutableSearchResponse mutableSearchResponse = this;
        synchronized (mutableSearchResponse) {
            this.failIfFrozen();
        }
        this.queryFailures.set(shardIndex, (Object)failure);
    }

    private SearchResponse buildResponse(long taskStartTimeNanos, InternalAggregations reducedAggs) {
        InternalSearchResponse internal = new InternalSearchResponse(new SearchHits(SearchHits.EMPTY, this.totalHits, Float.NaN), reducedAggs, null, null, false, Boolean.valueOf(false), this.reducePhase);
        long tookInMillis = TimeValue.timeValueNanos((long)(System.nanoTime() - taskStartTimeNanos)).getMillis();
        return new SearchResponse((SearchResponseSections)internal, null, this.totalShards, this.successfulShards, this.skippedShards, tookInMillis, this.buildQueryFailures(), this.clusters);
    }

    synchronized AsyncSearchResponse toAsyncSearchResponse(AsyncSearchTask task, long expirationTime, boolean restoreResponseHeaders) {
        SearchResponse searchResponse;
        if (restoreResponseHeaders && this.responseHeaders != null) {
            AsyncTaskIndexService.restoreResponseHeadersContext((ThreadContext)this.threadContext, this.responseHeaders);
        }
        if (this.finalResponse != null) {
            searchResponse = this.finalResponse;
        } else if (this.clusters == null) {
            searchResponse = null;
        } else {
            InternalAggregations reducedAggs = this.reducedAggsSource.get();
            this.reducedAggsSource = () -> reducedAggs;
            searchResponse = this.buildResponse(task.getStartTimeNanos(), reducedAggs);
        }
        return new AsyncSearchResponse(task.getExecutionId().getEncoded(), searchResponse, (Exception)this.failure, this.isPartial, !this.frozen, task.getStartTime(), expirationTime);
    }

    synchronized AsyncSearchResponse toAsyncSearchResponse(AsyncSearchTask task, long expirationTime, ElasticsearchException reduceException) {
        if (this.failure != null) {
            reduceException.addSuppressed((Throwable)this.failure);
        }
        return new AsyncSearchResponse(task.getExecutionId().getEncoded(), this.buildResponse(task.getStartTimeNanos(), null), (Exception)reduceException, this.isPartial, !this.frozen, task.getStartTime(), expirationTime);
    }

    private void failIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("invalid update received after the completion of the request");
        }
    }

    private ShardSearchFailure[] buildQueryFailures() {
        if (this.queryFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        for (int i = 0; i < this.queryFailures.length(); ++i) {
            ShardSearchFailure failure = (ShardSearchFailure)this.queryFailures.get(i);
            if (failure == null) continue;
            failures.add(failure);
        }
        return failures.toArray(new ShardSearchFailure[0]);
    }
}

