/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.LoggingTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.enrich.EnrichPolicyExecutor;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;

public class TransportExecuteEnrichPolicyAction
extends TransportMasterNodeAction<ExecuteEnrichPolicyAction.Request, ExecuteEnrichPolicyAction.Response> {
    private final EnrichPolicyExecutor executor;

    @Inject
    public TransportExecuteEnrichPolicyAction(Settings settings, Client client, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, EnrichPolicyLocks enrichPolicyLocks) {
        super("cluster:admin/xpack/enrich/execute", transportService, clusterService, threadPool, actionFilters, ExecuteEnrichPolicyAction.Request::new, indexNameExpressionResolver);
        this.executor = new EnrichPolicyExecutor(settings, clusterService, client, transportService.getTaskManager(), threadPool, indexNameExpressionResolver, enrichPolicyLocks, System::currentTimeMillis);
    }

    protected String executor() {
        return "same";
    }

    protected ExecuteEnrichPolicyAction.Response read(StreamInput in) throws IOException {
        return new ExecuteEnrichPolicyAction.Response(in);
    }

    protected void masterOperation(ExecuteEnrichPolicyAction.Request request, ClusterState state, final ActionListener<ExecuteEnrichPolicyAction.Response> listener) {
        if (state.getNodes().getIngestNodes().isEmpty()) {
            throw new IllegalStateException("no ingest nodes in this cluster");
        }
        if (request.isWaitForCompletion()) {
            this.executor.runPolicy(request, new ActionListener<ExecuteEnrichPolicyStatus>(){

                public void onResponse(ExecuteEnrichPolicyStatus executionStatus) {
                    listener.onResponse((Object)new ExecuteEnrichPolicyAction.Response(executionStatus));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            Task executeTask = this.executor.runPolicy(request, (TaskListener<ExecuteEnrichPolicyStatus>)LoggingTaskListener.instance());
            TaskId taskId = new TaskId(this.clusterService.localNode().getId(), executeTask.getId());
            listener.onResponse((Object)new ExecuteEnrichPolicyAction.Response(taskId));
        }
    }

    protected ClusterBlockException checkBlock(ExecuteEnrichPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

