/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.ObjectPath;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.EnrichPlugin;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class EnrichPolicyMaintenanceService
implements LocalNodeMasterListener {
    private static final Logger logger = LogManager.getLogger(EnrichPolicyMaintenanceService.class);
    private static final String MAPPING_POLICY_FIELD_PATH = "_meta.enrich_policy_name";
    private static final IndicesOptions IGNORE_UNAVAILABLE = IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)false, (boolean)false);
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final EnrichPolicyLocks enrichPolicyLocks;
    private volatile boolean isMaster = false;
    private volatile Scheduler.Cancellable cancellable;
    private final Semaphore maintenanceLock = new Semaphore(1);

    EnrichPolicyMaintenanceService(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, EnrichPolicyLocks enrichPolicyLocks) {
        this.settings = settings;
        this.client = new OriginSettingClient(client, "enrich");
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.enrichPolicyLocks = enrichPolicyLocks;
    }

    void initialize() {
        this.clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
    }

    public void onMaster() {
        if (this.cancellable == null || this.cancellable.isCancelled()) {
            this.isMaster = true;
            this.scheduleNext();
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    EnrichPolicyMaintenanceService.this.offMaster();
                }
            });
        }
    }

    public void offMaster() {
        if (this.cancellable != null && !this.cancellable.isCancelled()) {
            this.isMaster = false;
            this.cancellable.cancel();
        }
    }

    private void scheduleNext() {
        if (this.isMaster) {
            try {
                TimeValue waitTime = (TimeValue)EnrichPlugin.ENRICH_CLEANUP_PERIOD.get(this.settings);
                this.cancellable = this.threadPool.schedule(this::execute, waitTime, "generic");
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("Failed to schedule next [enrich] maintenance task; Shutting down", (Throwable)e);
                }
                throw e;
            }
        } else {
            logger.debug("No longer master; Skipping next scheduled [enrich] maintenance task");
        }
    }

    private void execute() {
        logger.debug("Triggering scheduled [enrich] maintenance task");
        if (this.isMaster) {
            this.maybeCleanUpEnrichIndices();
            this.scheduleNext();
        } else {
            logger.debug("No longer master; Skipping next scheduled [enrich] maintenance task");
        }
    }

    private void maybeCleanUpEnrichIndices() {
        if (this.maintenanceLock.tryAcquire()) {
            this.cleanUpEnrichIndices();
        } else {
            logger.debug("Previous [enrich] maintenance task still in progress; Skipping this execution");
        }
    }

    void concludeMaintenance() {
        this.maintenanceLock.release();
    }

    void cleanUpEnrichIndices() {
        final Map<String, EnrichPolicy> policies = EnrichStore.getPolicies(this.clusterService.state());
        GetIndexRequest indices = (GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(new String[]{".enrich-*"})).indicesOptions(IndicesOptions.lenientExpand());
        final EnrichPolicyLocks.EnrichPolicyExecutionState executionState = this.enrichPolicyLocks.captureExecutionState();
        if (!executionState.isAnyPolicyInFlight()) {
            this.client.admin().indices().getIndex(indices, (ActionListener)new ActionListener<GetIndexResponse>(){

                public void onResponse(GetIndexResponse getIndexResponse) {
                    if (EnrichPolicyMaintenanceService.this.enrichPolicyLocks.isSameState(executionState)) {
                        String[] removeIndices = (String[])Arrays.stream(getIndexResponse.getIndices()).filter(indexName -> EnrichPolicyMaintenanceService.this.shouldRemoveIndex(getIndexResponse, policies, indexName)).toArray(String[]::new);
                        EnrichPolicyMaintenanceService.this.deleteIndices(removeIndices);
                    } else {
                        logger.debug("Skipping enrich index cleanup since enrich policy was executed while gathering indices");
                        EnrichPolicyMaintenanceService.this.concludeMaintenance();
                    }
                }

                public void onFailure(Exception e) {
                    logger.error("Failed to get indices during enrich index maintenance task", (Throwable)e);
                    EnrichPolicyMaintenanceService.this.concludeMaintenance();
                }
            });
        } else {
            this.concludeMaintenance();
        }
    }

    private boolean shouldRemoveIndex(GetIndexResponse getIndexResponse, Map<String, EnrichPolicy> policies, String indexName) {
        logger.debug("Checking if should remove enrich index [{}]", (Object)indexName);
        ImmutableOpenMap indexMapping = (ImmutableOpenMap)getIndexResponse.getMappings().get((Object)indexName);
        MappingMetadata mappingMetadata = (MappingMetadata)indexMapping.get((Object)"_doc");
        Map mapping = mappingMetadata.getSourceAsMap();
        String policyName = (String)ObjectPath.eval((String)MAPPING_POLICY_FIELD_PATH, (Object)mapping);
        if (policyName == null || !policies.containsKey(policyName)) {
            logger.debug("Enrich index [{}] does not correspond to any existing policy. Found policy name [{}]", (Object)indexName, (Object)policyName);
            return true;
        }
        String aliasName = EnrichPolicy.getBaseName((String)policyName);
        List aliasMetadata = (List)getIndexResponse.aliases().get((Object)indexName);
        if (aliasMetadata == null) {
            logger.debug("Enrich index [{}] is not marked as a live index since it has no alias information", (Object)indexName);
            return true;
        }
        boolean hasAlias = aliasMetadata.stream().anyMatch(am -> am.getAlias().equals(aliasName));
        if (!hasAlias) {
            logger.debug("Enrich index [{}] is not marked as a live index since it lacks the alias [{}]", (Object)indexName, (Object)aliasName);
            return true;
        }
        logger.debug("Enrich index [{}] was spared since it is associated with the valid policy [{}] and references alias [{}]", (Object)indexName, (Object)policyName, (Object)aliasName);
        return false;
    }

    private void deleteIndices(final String[] removeIndices) {
        if (removeIndices.length != 0) {
            DeleteIndexRequest deleteIndices = new DeleteIndexRequest().indices(removeIndices).indicesOptions(IGNORE_UNAVAILABLE);
            this.client.admin().indices().delete(deleteIndices, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    logger.debug("Completed deletion of stale enrich indices [{}]", new Supplier[]{() -> Arrays.toString(removeIndices)});
                    EnrichPolicyMaintenanceService.this.concludeMaintenance();
                }

                public void onFailure(Exception e) {
                    logger.error(() -> "Enrich maintenance task could not delete abandoned enrich indices [" + Arrays.toString(removeIndices) + "]", (Throwable)e);
                    EnrichPolicyMaintenanceService.this.concludeMaintenance();
                }
            });
        } else {
            this.concludeMaintenance();
        }
    }
}

