/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestGetUserPrivilegesAction
extends SecurityBaseRestHandler {
    private final SecurityContext securityContext;

    public RestGetUserPrivilegesAction(Settings settings, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_security/user/_privileges", RestRequest.Method.GET, "/_xpack/security/user/_privileges"));
    }

    public String getName() {
        return "security_user_privileges_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        User user = this.securityContext.getUser();
        if (user == null) {
            return restChannel -> {
                throw new ElasticsearchSecurityException("there is no authenticated user", new Object[0]);
            };
        }
        String username = user.principal();
        GetUserPrivilegesRequestBuilder requestBuilder = new SecurityClient((ElasticsearchClient)client).prepareGetUserPrivileges(username);
        return channel -> requestBuilder.execute((ActionListener)new RestListener((RestChannel)channel));
    }

    static class RestListener
    extends RestBuilderListener<GetUserPrivilegesResponse> {
        RestListener(RestChannel channel) {
            super(channel);
        }

        public RestResponse buildResponse(GetUserPrivilegesResponse response, XContentBuilder builder) throws Exception {
            builder.startObject();
            builder.field(RoleDescriptor.Fields.CLUSTER.getPreferredName(), (Iterable)response.getClusterPrivileges());
            builder.startArray(RoleDescriptor.Fields.GLOBAL.getPreferredName());
            for (ConfigurableClusterPrivilege ccp : response.getConditionalClusterPrivileges()) {
                ConfigurableClusterPrivileges.toXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, Collections.singleton(ccp));
            }
            builder.endArray();
            builder.field(RoleDescriptor.Fields.INDICES.getPreferredName(), (Iterable)response.getIndexPrivileges());
            builder.field(RoleDescriptor.Fields.APPLICATIONS.getPreferredName(), (Iterable)response.getApplicationPrivileges());
            builder.field(RoleDescriptor.Fields.RUN_AS.getPreferredName(), (Iterable)response.getRunAs());
            builder.endObject();
            return new BytesRestResponse(RestStatus.OK, builder);
        }
    }
}

