/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestChangePasswordAction
extends SecurityBaseRestHandler
implements RestRequestFilter {
    private final SecurityContext securityContext;
    private final Hasher passwordHasher;
    private static final Set<String> FILTERED_FIELDS = Collections.singleton("password");

    public RestChangePasswordAction(Settings settings, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
        this.passwordHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_security/user/{username}/_password", RestRequest.Method.PUT, "/_xpack/security/user/{username}/_password"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_security/user/{username}/_password", RestRequest.Method.POST, "/_xpack/security/user/{username}/_password"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_security/user/_password", RestRequest.Method.PUT, "/_xpack/security/user/_password"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_security/user/_password", RestRequest.Method.POST, "/_xpack/security/user/_password")));
    }

    public String getName() {
        return "security_change_password_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        User user = this.securityContext.getUser();
        String username = request.param("username") == null ? user.principal() : request.param("username");
        String refresh = request.param("refresh");
        return channel -> ((ChangePasswordRequestBuilder)new SecurityClient((ElasticsearchClient)client).prepareChangePassword(username, request.requiredContent(), request.getXContentType(), this.passwordHasher).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<ChangePasswordResponse>(channel){

            public RestResponse buildResponse(ChangePasswordResponse changePasswordResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

