/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oidc;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateResponse;
import org.elasticsearch.xpack.security.rest.action.oidc.OpenIdConnectBaseRestHandler;

public class RestOpenIdConnectAuthenticateAction
extends OpenIdConnectBaseRestHandler
implements RestRequestFilter {
    private static final Logger logger = LogManager.getLogger();
    static final ObjectParser<OpenIdConnectAuthenticateRequest, Void> PARSER = new ObjectParser("oidc_authn", OpenIdConnectAuthenticateRequest::new);
    private static final Set<String> FILTERED_FIELDS;

    public RestOpenIdConnectAuthenticateAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_security/oidc/authenticate"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            OpenIdConnectAuthenticateRequest authenticateRequest = (OpenIdConnectAuthenticateRequest)PARSER.parse(parser, null);
            logger.trace("OIDC Authenticate: " + authenticateRequest);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)OpenIdConnectAuthenticateAction.INSTANCE, (ActionRequest)authenticateRequest, (ActionListener)new RestBuilderListener<OpenIdConnectAuthenticateResponse>(channel){

                public RestResponse buildResponse(OpenIdConnectAuthenticateResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject().field("username", response.getPrincipal()).field("access_token", response.getAccessTokenString()).field("refresh_token", response.getRefreshTokenString()).field("expires_in", response.getExpiresIn().seconds()).endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    public String getName() {
        return "security_oidc_authenticate_action";
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        PARSER.declareString(OpenIdConnectAuthenticateRequest::setRedirectUri, new ParseField("redirect_uri", new String[0]));
        PARSER.declareString(OpenIdConnectAuthenticateRequest::setState, new ParseField("state", new String[0]));
        PARSER.declareString(OpenIdConnectAuthenticateRequest::setNonce, new ParseField("nonce", new String[0]));
        PARSER.declareStringOrNull(OpenIdConnectAuthenticateRequest::setRealm, new ParseField("realm", new String[0]));
        FILTERED_FIELDS = Collections.singleton("redirect_uri");
    }
}

