/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestCreateApiKeyAction
extends ApiKeyBaseRestHandler {
    public RestCreateApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_security/api_key"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key")));
    }

    public String getName() {
        return "xpack_security_create_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            String refresh = request.param("refresh");
            CreateApiKeyRequestBuilder builder = new SecurityClient((ElasticsearchClient)client).prepareCreateApiKey(request.requiredContent(), request.getXContentType()).setRefreshPolicy(refresh != null ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : CreateApiKeyRequest.DEFAULT_REFRESH_POLICY);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> builder.execute((ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }
}

