/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

abstract class ApiKeyBaseRestHandler
extends SecurityBaseRestHandler {
    private static final Logger logger = LogManager.getLogger();

    ApiKeyBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    @Override
    protected Exception checkFeatureAvailable(RestRequest request) {
        Exception failedFeature = super.checkFeatureAvailable(request);
        if (failedFeature != null) {
            return failedFeature;
        }
        if (this.licenseState.checkFeature(XPackLicenseState.Feature.SECURITY_API_KEY_SERVICE)) {
            return null;
        }
        logger.info("API Keys are not available under the current [{}] license", (Object)this.licenseState.getOperationMode().description());
        return LicenseUtils.newComplianceException((String)"api keys");
    }
}

