/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;

public class SecurityRestFilter
implements RestHandler {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final RestHandler restHandler;
    private final AuthenticationService authenticationService;
    private final SecondaryAuthenticator secondaryAuthenticator;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final boolean extractClientCertificate;

    public SecurityRestFilter(XPackLicenseState licenseState, ThreadContext threadContext, AuthenticationService authenticationService, SecondaryAuthenticator secondaryAuthenticator, RestHandler restHandler, boolean extractClientCertificate) {
        this.licenseState = licenseState;
        this.threadContext = threadContext;
        this.authenticationService = authenticationService;
        this.secondaryAuthenticator = secondaryAuthenticator;
        this.restHandler = restHandler;
        this.extractClientCertificate = extractClientCertificate;
    }

    public boolean allowSystemIndexAccessByDefault() {
        return this.restHandler.allowSystemIndexAccessByDefault();
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (this.licenseState.isSecurityEnabled() && request.method() != RestRequest.Method.OPTIONS) {
            if (this.extractClientCertificate) {
                HttpChannel httpChannel = request.getHttpChannel();
                SSLEngineUtils.extractClientCertificates(logger, this.threadContext, httpChannel);
            }
            String requestUri = request.uri();
            this.authenticationService.authenticate(this.maybeWrapRestRequest(request), (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                if (authentication == null) {
                    logger.trace("No authentication available for REST request [{}]", (Object)requestUri);
                } else {
                    logger.trace("Authenticated REST request [{}] as {}", (Object)requestUri, authentication);
                }
                this.secondaryAuthenticator.authenticateAndAttachToContext(request, (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
                    if (secondaryAuthentication != null) {
                        logger.trace("Found secondary authentication {} in REST request [{}]", secondaryAuthentication, (Object)requestUri);
                    }
                    RemoteHostHeader.process(request, this.threadContext);
                    this.restHandler.handleRequest(request, channel, client);
                }, e -> this.handleException("Secondary authentication", request, channel, (Exception)e)));
            }, e -> this.handleException("Authentication", request, channel, (Exception)e)));
        } else {
            this.restHandler.handleRequest(request, channel, client);
        }
    }

    private void handleException(String actionType, RestRequest request, RestChannel channel, Exception e) {
        logger.debug((Message)new ParameterizedMessage("{} failed for REST request [{}]", (Object)actionType, (Object)request.uri()), (Throwable)e);
        final RestStatus restStatus = ExceptionsHelper.status((Throwable)e);
        try {
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, restStatus, e){

                protected boolean skipStackTrace() {
                    return restStatus == RestStatus.UNAUTHORIZED;
                }
            });
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
        }
    }

    public boolean canTripCircuitBreaker() {
        return this.restHandler.canTripCircuitBreaker();
    }

    public boolean supportsContentStream() {
        return this.restHandler.supportsContentStream();
    }

    public boolean allowsUnsafeBuffers() {
        return this.restHandler.allowsUnsafeBuffers();
    }

    public List<RestHandler.Route> routes() {
        return this.restHandler.routes();
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return this.restHandler.deprecatedRoutes();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return this.restHandler.replacedRoutes();
    }

    private RestRequest maybeWrapRestRequest(RestRequest restRequest) throws IOException {
        if (this.restHandler instanceof RestRequestFilter) {
            return ((RestRequestFilter)this.restHandler).getFilteredRequest(restRequest);
        }
        return restRequest;
    }
}

