/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.privilege;

import java.io.IOException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheRequest;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheResponse;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportClearPrivilegesCacheAction
extends TransportNodesAction<ClearPrivilegesCacheRequest, ClearPrivilegesCacheResponse, ClearPrivilegesCacheRequest.Node, ClearPrivilegesCacheResponse.Node> {
    private final NativePrivilegeStore privilegesStore;
    private final CompositeRolesStore rolesStore;

    @Inject
    public TransportClearPrivilegesCacheAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NativePrivilegeStore privilegesStore, CompositeRolesStore rolesStore) {
        super("cluster:admin/xpack/security/privilege/cache/clear", threadPool, clusterService, transportService, actionFilters, ClearPrivilegesCacheRequest::new, ClearPrivilegesCacheRequest.Node::new, "management", ClearPrivilegesCacheResponse.Node.class);
        this.privilegesStore = privilegesStore;
        this.rolesStore = rolesStore;
    }

    protected ClearPrivilegesCacheResponse newResponse(ClearPrivilegesCacheRequest request, java.util.List<ClearPrivilegesCacheResponse.Node> nodes, java.util.List<FailedNodeException> failures) {
        return new ClearPrivilegesCacheResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected ClearPrivilegesCacheRequest.Node newNodeRequest(ClearPrivilegesCacheRequest request) {
        return new ClearPrivilegesCacheRequest.Node(request);
    }

    protected ClearPrivilegesCacheResponse.Node newNodeResponse(StreamInput in) throws IOException {
        return new ClearPrivilegesCacheResponse.Node(in);
    }

    protected ClearPrivilegesCacheResponse.Node nodeOperation(ClearPrivilegesCacheRequest.Node request) {
        if (request.getApplicationNames() == null || request.getApplicationNames().length == 0) {
            this.privilegesStore.invalidateAll();
        } else {
            this.privilegesStore.invalidate(List.of((Object[])request.getApplicationNames()));
        }
        if (request.clearRolesCache()) {
            this.rolesStore.invalidateAll();
        }
        return new ClearPrivilegesCacheResponse.Node(this.clusterService.localNode());
    }
}

