/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.querydsl.container;

import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class SearchHitFieldRef
implements FieldExtraction {
    private final String name;
    private final String fullFieldName;
    private final DataType dataType;
    private final boolean docValue;
    private final String hitName;

    public SearchHitFieldRef(String name, String fullFieldName, DataType dataType, boolean useDocValueInsteadOfSource, boolean isAlias) {
        this(name, fullFieldName, dataType, useDocValueInsteadOfSource, isAlias, null);
    }

    public SearchHitFieldRef(String name, String fullFieldName, DataType dataType, boolean useDocValueInsteadOfSource, boolean isAlias, String hitName) {
        this.name = name;
        this.fullFieldName = fullFieldName;
        this.dataType = dataType;
        this.docValue = isAlias ? useDocValueInsteadOfSource : (SearchHitFieldRef.hasDocValues(dataType) ? useDocValueInsteadOfSource : false);
        this.hitName = hitName;
    }

    public String hitName() {
        return this.hitName;
    }

    public String name() {
        return this.name;
    }

    public String fullFieldName() {
        return this.fullFieldName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean useDocValue() {
        return this.docValue;
    }

    public void collectFields(QlSourceBuilder sourceBuilder) {
        if (this.hitName != null) {
            return;
        }
        if (this.docValue) {
            sourceBuilder.addDocField(this.name, SearchHitFieldRef.format(this.dataType));
        } else {
            sourceBuilder.addSourceField(this.name);
        }
    }

    public final boolean supportedByAggsOnlyQuery() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    private static boolean hasDocValues(DataType dataType) {
        return dataType == DataTypes.KEYWORD || dataType == DataTypes.DATETIME;
    }

    private static String format(DataType dataType) {
        return dataType == DataTypes.DATETIME ? "epoch_millis" : null;
    }
}

