/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.querydsl.container;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.eql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.ConstantInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class FieldExtractorRegistry {
    private final Map<String, FieldExtraction> cache = new HashMap<String, FieldExtraction>();

    public FieldExtraction fieldExtraction(Expression expression) {
        return this.cache.computeIfAbsent(Expressions.id((Expression)expression), k -> this.createFieldExtractionFor(expression));
    }

    private FieldExtraction createFieldExtractionFor(Expression expression) {
        if (expression instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)expression;
            if (fa.isNested()) {
                throw new UnsupportedOperationException("Nested not yet supported");
            }
            return this.topHitFieldExtractor(fa);
        }
        if (expression.foldable()) {
            return new ComputedRef((Pipe)new ConstantInput(expression.source(), expression, expression.fold()));
        }
        throw new EqlIllegalArgumentException("Unsupported expression [{}]", expression);
    }

    private FieldExtraction topHitFieldExtractor(FieldAttribute fieldAttr) {
        FieldAttribute actualField = fieldAttr;
        FieldAttribute rootField = fieldAttr;
        StringBuilder fullFieldName = new StringBuilder(fieldAttr.field().getName());
        if (!fieldAttr.field().isAlias()) {
            while (actualField.parent() != null && actualField.parent().field().getDataType() != DataTypes.OBJECT && actualField.parent().field().getDataType() != DataTypes.NESTED && !actualField.field().getDataType().hasDocValues()) {
                actualField = actualField.parent();
            }
        }
        while (rootField.parent() != null) {
            fullFieldName.insert(0, ".").insert(0, rootField.parent().field().getName());
            rootField = rootField.parent();
        }
        return new SearchHitFieldRef(actualField.name(), fullFieldName.toString(), fieldAttr.field().getDataType(), fieldAttr.field().isAggregatable(), fieldAttr.field().isAlias());
    }
}

