/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.eql.action.EqlSearchAction;
import org.elasticsearch.xpack.eql.action.EqlSearchRequest;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.eql.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.eql.execution.PlanExecutor;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.Results;
import org.elasticsearch.xpack.ql.expression.Order;

public class TransportEqlSearchAction
extends HandledTransportAction<EqlSearchRequest, EqlSearchResponse>
implements AsyncTaskManagementService.AsyncOperation<EqlSearchRequest, EqlSearchResponse, EqlSearchTask> {
    private final SecurityContext securityContext;
    private final ClusterService clusterService;
    private final PlanExecutor planExecutor;
    private final ThreadPool threadPool;
    private final AsyncTaskManagementService<EqlSearchRequest, EqlSearchResponse, EqlSearchTask> asyncTaskManagementService;

    @Inject
    public TransportEqlSearchAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor, NamedWriteableRegistry registry, Client client) {
        super("indices:data/read/eql", transportService, actionFilters, EqlSearchRequest::new);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.clusterService = clusterService;
        this.planExecutor = planExecutor;
        this.threadPool = threadPool;
        this.asyncTaskManagementService = new AsyncTaskManagementService<EqlSearchRequest, EqlSearchResponse, EqlSearchTask>(".async-search", client, "async_search", registry, this.taskManager, EqlSearchAction.INSTANCE.name(), this, EqlSearchTask.class, clusterService, threadPool);
    }

    @Override
    public EqlSearchTask createTask(EqlSearchRequest request, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId) {
        return new EqlSearchTask(id, type, action, request.getDescription(), parentTaskId, headers, originHeaders, asyncExecutionId, request.keepAlive());
    }

    @Override
    public void execute(EqlSearchRequest request, EqlSearchTask task, ActionListener<EqlSearchResponse> listener) {
        TransportEqlSearchAction.operation(this.planExecutor, task, request, TransportEqlSearchAction.username(this.securityContext), TransportEqlSearchAction.clusterName(this.clusterService), this.clusterService.localNode().getId(), listener);
    }

    @Override
    public EqlSearchResponse initialResponse(EqlSearchTask task) {
        return new EqlSearchResponse(EqlSearchResponse.Hits.EMPTY, this.threadPool.relativeTimeInMillis() - task.getStartTime(), false, task.getExecutionId().getEncoded(), true, true);
    }

    @Override
    public EqlSearchResponse readResponse(StreamInput inputStream) throws IOException {
        return new EqlSearchResponse(inputStream);
    }

    protected void doExecute(Task task, EqlSearchRequest request, ActionListener<EqlSearchResponse> listener) {
        if (request.waitForCompletionTimeout() != null && request.waitForCompletionTimeout().getMillis() >= 0L) {
            this.asyncTaskManagementService.asyncExecute(request, request.waitForCompletionTimeout(), request.keepAlive(), request.keepOnCompletion(), listener);
        } else {
            TransportEqlSearchAction.operation(this.planExecutor, (EqlSearchTask)task, request, TransportEqlSearchAction.username(this.securityContext), TransportEqlSearchAction.clusterName(this.clusterService), this.clusterService.localNode().getId(), listener);
        }
    }

    public static void operation(PlanExecutor planExecutor, EqlSearchTask task, EqlSearchRequest request, String username, String clusterName, String nodeId, ActionListener<EqlSearchResponse> listener) {
        ZoneId zoneId = DateUtils.of((String)"Z");
        QueryBuilder filter = request.filter();
        TimeValue timeout = TimeValue.timeValueSeconds((long)30L);
        String clientId = null;
        ParserParams params = new ParserParams(zoneId).fieldEventCategory(request.eventCategoryField()).fieldTimestamp(request.timestampField()).fieldTiebreaker(request.tiebreakerField()).resultPosition("tail".equals(request.resultPosition()) ? Order.OrderDirection.DESC : Order.OrderDirection.ASC).size(request.size()).fetchSize(request.fetchSize());
        EqlConfiguration cfg = new EqlConfiguration(request.indices(), zoneId, username, clusterName, filter, timeout, request.indicesOptions(), request.fetchSize(), clientId, new TaskId(nodeId, task.getId()), task);
        planExecutor.eql(cfg, request.query(), params, (ActionListener<Results>)ActionListener.wrap(r -> listener.onResponse((Object)TransportEqlSearchAction.createResponse(r, task.getExecutionId())), arg_0 -> listener.onFailure(arg_0)));
    }

    static EqlSearchResponse createResponse(Results results, AsyncExecutionId id) {
        EqlSearchResponse.Hits hits = new EqlSearchResponse.Hits(results.events(), results.sequences(), results.totalHits());
        if (id != null) {
            return new EqlSearchResponse(hits, results.tookTime().getMillis(), results.timedOut(), id.getEncoded(), false, false);
        }
        return new EqlSearchResponse(hits, results.tookTime().getMillis(), results.timedOut());
    }

    static String username(SecurityContext securityContext) {
        return securityContext != null && securityContext.getUser() != null ? securityContext.getUser().principal() : null;
    }

    static String clusterName(ClusterService clusterService) {
        return clusterService.getClusterName().value();
    }
}

