/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.physical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class UnaryExec
extends PhysicalPlan {
    private final PhysicalPlan child;

    protected UnaryExec(Source source, PhysicalPlan child) {
        super(source, Collections.singletonList(child));
        this.child = child;
    }

    public final PhysicalPlan replaceChildren(List<PhysicalPlan> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return this.replaceChild(newChildren.get(0));
    }

    protected abstract UnaryExec replaceChild(PhysicalPlan var1);

    public PhysicalPlan child() {
        return this.child;
    }

    @Override
    public List<Attribute> output() {
        return this.child.output();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExec other = (UnaryExec)obj;
        return Objects.equals(this.child, other.child);
    }
}

