/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.EndsWithFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.EndsWithFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseSensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class EndsWith
extends CaseSensitiveScalarFunction {
    private final Expression input;
    private final Expression pattern;

    public EndsWith(Source source, Expression input, Expression pattern, Configuration configuration) {
        super(source, Arrays.asList(input, pattern), configuration);
        this.input = input;
        this.pattern = pattern;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        return TypeResolutions.isStringAndExact((Expression)this.pattern, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
    }

    public Expression input() {
        return this.input;
    }

    public Expression pattern() {
        return this.pattern;
    }

    protected Pipe makePipe() {
        return new EndsWithFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.pattern), this.isCaseSensitive());
    }

    public boolean foldable() {
        return this.input.foldable() && this.pattern.foldable();
    }

    public Object fold() {
        return EndsWithFunctionProcessor.doProcess(this.input.fold(), this.pattern.fold(), this.isCaseSensitive());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, EndsWith::new, (Object)this.input, (Object)this.pattern, (Object)this.configuration());
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate patternScript = this.asScript(this.pattern);
        return this.asScriptFrom(inputScript, patternScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate patternScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s,%s,%s)"), "endsWith", inputScript.template(), patternScript.template(), "{}"), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(patternScript.params()).variable((Object)this.isCaseSensitive()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new EndsWith(this.source(), newChildren.get(0), newChildren.get(1), this.configuration());
    }
}

