/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ConcatFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ConcatFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Concat
extends ScalarFunction {
    private final List<Expression> values;

    public Concat(Source source, List<Expression> values) {
        super(source, values);
        this.values = values;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = Expression.TypeResolution.TYPE_RESOLVED;
        for (Expression value : this.values) {
            resolution = TypeResolutions.isExact((Expression)value, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.DEFAULT);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    protected Pipe makePipe() {
        return new ConcatFunctionPipe(this.source(), (Expression)this, Expressions.pipe(this.values));
    }

    public boolean foldable() {
        return Expressions.foldable(this.values);
    }

    public Object fold() {
        return ConcatFunctionProcessor.doProcess(Expressions.fold(this.values));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Concat::new, this.values);
    }

    public ScriptTemplate asScript() {
        ArrayList<ScriptTemplate> templates = new ArrayList<ScriptTemplate>();
        for (Expression ex : this.children()) {
            templates.add(this.asScript(ex));
        }
        StringJoiner template = new StringJoiner(",", "{eql}.concat([", "])");
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        for (ScriptTemplate scriptTemplate : templates) {
            template.add(scriptTemplate.template());
            params.script(scriptTemplate.params());
        }
        return new ScriptTemplate(this.formatTemplate(template.toString()), params.build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Concat(this.source(), newChildren);
    }
}

