/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.execution.assembler.BoxedQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.Criterion;
import org.elasticsearch.xpack.eql.execution.assembler.Executable;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceMatcher;
import org.elasticsearch.xpack.eql.execution.sequence.SequencePayload;
import org.elasticsearch.xpack.eql.session.EmptyPayload;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.eql.util.ReversedIterator;
import org.elasticsearch.xpack.ql.util.ActionListeners;

public class TumblingWindow
implements Executable {
    private final Logger log = LogManager.getLogger(TumblingWindow.class);
    private final QueryClient client;
    private final List<Criterion<BoxedQueryRequest>> criteria;
    private final Criterion<BoxedQueryRequest> until;
    private final SequenceMatcher matcher;
    private final int maxStages;
    private final int windowSize;
    private boolean restartWindowFromTailQuery;
    private long startTime;

    public TumblingWindow(QueryClient client, List<Criterion<BoxedQueryRequest>> criteria, Criterion<BoxedQueryRequest> until, SequenceMatcher matcher) {
        this.client = client;
        this.until = until;
        this.criteria = criteria;
        this.maxStages = criteria.size();
        this.matcher = matcher;
        Criterion<BoxedQueryRequest> baseRequest = criteria.get(0);
        this.windowSize = baseRequest.queryRequest().searchSource().size();
        this.restartWindowFromTailQuery = baseRequest.descending();
    }

    @Override
    public void execute(ActionListener<Payload> listener) {
        this.log.trace("Starting sequence window w/ fetch size [{}]", (Object)this.windowSize);
        this.startTime = System.currentTimeMillis();
        this.tumbleWindow(0, listener);
    }

    private void tumbleWindow(int currentStage, ActionListener<Payload> listener) {
        if (currentStage > 0 && !this.matcher.hasCandidates()) {
            if (this.restartWindowFromTailQuery) {
                currentStage = 0;
            } else {
                this.payload(listener);
                return;
            }
        }
        this.log.trace("Tumbling window...");
        if (this.restartWindowFromTailQuery) {
            if (currentStage == 0) {
                this.matcher.trim(null);
            }
        } else {
            Ordinal marker = this.criteria.get(currentStage).queryRequest().after();
            if (marker != null) {
                this.matcher.trim(marker);
            }
        }
        this.advance(currentStage, listener);
    }

    private void rebaseWindow(int nextStage, ActionListener<Payload> listener) {
        this.log.trace("Rebasing window...");
        this.advance(nextStage, listener);
    }

    private void advance(int stage, ActionListener<Payload> listener) {
        Criterion<BoxedQueryRequest> base = this.criteria.get(stage);
        base.queryRequest().to(null);
        this.log.trace("{}", (Object)this.matcher);
        this.log.trace("Querying base stage [{}] {}", (Object)stage, (Object)base.queryRequest());
        this.client.query(base.queryRequest(), (ActionListener<SearchResponse>)ActionListener.wrap(p -> this.baseCriterion(stage, (SearchResponse)p, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void baseCriterion(int baseStage, SearchResponse r, ActionListener<Payload> listener) {
        WindowInfo info;
        Criterion<BoxedQueryRequest> base = this.criteria.get(baseStage);
        List<SearchHit> hits = RuntimeUtils.searchHits(r);
        this.log.trace("Found [{}] hits", (Object)hits.size());
        Ordinal begin = null;
        Ordinal end = null;
        if (!hits.isEmpty()) {
            begin = TumblingWindow.headOrdinal(hits, base);
            end = TumblingWindow.tailOrdinal(hits, base);
            info = new WindowInfo(baseStage, begin, end);
            this.log.trace("Found {}base [{}] window {}->{}", (Object)(base.descending() ? "tail " : ""), (Object)base.stage(), (Object)begin, (Object)end);
            base.queryRequest().nextAfter(end);
            if (this.until != null && baseStage > 0) {
                this.untilCriterion(info, listener, () -> this.completeBaseCriterion(baseStage, hits, info, listener));
                return;
            }
        } else {
            info = null;
        }
        this.completeBaseCriterion(baseStage, hits, info, listener);
    }

    private void completeBaseCriterion(int baseStage, List<SearchHit> hits, WindowInfo info, ActionListener<Payload> listener) {
        boolean windowCompleted;
        Criterion<BoxedQueryRequest> base = this.criteria.get(baseStage);
        if (!this.matcher.match(baseStage, this.wrapValues(base, hits))) {
            this.payload(listener);
            return;
        }
        int nextStage = baseStage + 1;
        boolean bl = windowCompleted = hits.size() < this.windowSize;
        if (nextStage < this.maxStages) {
            boolean descendingQuery = base.descending();
            Runnable next = null;
            if (info != null) {
                if (descendingQuery) {
                    this.setupWindowFromTail(info.end);
                } else {
                    this.boxQuery(info, this.criteria.get(nextStage));
                }
            }
            if (windowCompleted) {
                boolean shouldTerminate = false;
                if (descendingQuery) {
                    if (info != null) {
                        this.restartWindowFromTailQuery = false;
                        next = () -> this.advance(1, listener);
                    } else {
                        shouldTerminate = true;
                    }
                } else if (this.matcher.hasFollowingCandidates(baseStage)) {
                    next = () -> this.rebaseWindow(nextStage, listener);
                } else if (!this.restartWindowFromTailQuery) {
                    shouldTerminate = true;
                } else {
                    next = () -> this.tumbleWindow(0, listener);
                }
                if (shouldTerminate) {
                    this.payload(listener);
                    return;
                }
            } else {
                next = descendingQuery ? () -> this.advance(1, listener) : () -> this.secondaryCriterion(info, nextStage, listener);
            }
            if (this.until != null && info != null && info.baseStage == 0) {
                this.untilCriterion(info, listener, next);
            } else {
                next.run();
            }
        } else if (windowCompleted) {
            if (this.restartWindowFromTailQuery) {
                this.tumbleWindow(0, listener);
            } else {
                this.payload(listener);
            }
        } else {
            this.tumbleWindow(baseStage, listener);
        }
    }

    private void untilCriterion(WindowInfo window, ActionListener<Payload> listener, Runnable next) {
        BoxedQueryRequest request = this.until.queryRequest();
        this.boxQuery(window, this.until);
        if (request.after().after(window.end)) {
            this.log.trace("Skipping until stage {}", (Object)request);
            next.run();
            return;
        }
        this.log.trace("Querying until stage {}", (Object)request);
        this.client.query(request, (ActionListener<SearchResponse>)ActionListener.wrap(r -> {
            List<SearchHit> hits = RuntimeUtils.searchHits(r);
            this.log.trace("Found [{}] hits", (Object)hits.size());
            if (!hits.isEmpty()) {
                request.nextAfter(TumblingWindow.tailOrdinal(hits, this.until));
                this.matcher.until(this.wrapUntilValues(this.wrapValues(this.until, hits)));
            }
            if (hits.size() == this.windowSize && request.after().before(window.end)) {
                this.untilCriterion(window, listener, next);
            } else {
                next.run();
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void secondaryCriterion(WindowInfo window, int currentStage, ActionListener<Payload> listener) {
        Criterion<BoxedQueryRequest> criterion = this.criteria.get(currentStage);
        BoxedQueryRequest request = criterion.queryRequest();
        this.log.trace("Querying (secondary) stage [{}] {}", (Object)criterion.stage(), (Object)request);
        this.client.query(request, (ActionListener<SearchResponse>)ActionListener.wrap(r -> {
            List<SearchHit> hits = RuntimeUtils.searchHits(r);
            hits = this.trim(hits, criterion, window.end);
            this.log.trace("Found [{}] hits", (Object)hits.size());
            int nextStage = currentStage + 1;
            if (!hits.isEmpty()) {
                BoxedQueryRequest nextRequest;
                Ordinal tailOrdinal = TumblingWindow.tailOrdinal(hits, criterion);
                Ordinal headOrdinal = TumblingWindow.headOrdinal(hits, criterion);
                this.log.trace("Found range [{}] -> [{}]", (Object)headOrdinal, (Object)tailOrdinal);
                if (tailOrdinal.after(window.end)) {
                    tailOrdinal = window.end;
                }
                request.nextAfter(tailOrdinal);
                if (!this.matcher.match(criterion.stage(), this.wrapValues(criterion, hits))) {
                    this.payload(listener);
                    return;
                }
                if (nextStage < this.maxStages && ((nextRequest = this.criteria.get(nextStage).queryRequest()).from() == null || nextRequest.after() == null)) {
                    nextRequest.from(headOrdinal);
                    nextRequest.nextAfter(headOrdinal);
                }
            }
            if (hits.size() == this.windowSize && request.after().before(window.end)) {
                this.secondaryCriterion(window, currentStage, listener);
            } else if (currentStage + 1 < this.maxStages && this.matcher.hasFollowingCandidates(criterion.stage())) {
                this.secondaryCriterion(window, currentStage + 1, listener);
            } else {
                this.tumbleWindow(window.baseStage, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private List<SearchHit> trim(List<SearchHit> searchHits, Criterion<BoxedQueryRequest> criterion, Ordinal boundary) {
        Ordinal ordinal;
        int offset = 0;
        for (int i = searchHits.size() - 1; i >= 0 && (ordinal = criterion.ordinal(searchHits.get(i))).after(boundary); --i) {
            ++offset;
        }
        return offset == 0 ? searchHits : searchHits.subList(0, searchHits.size() - offset);
    }

    private void boxQuery(WindowInfo window, Criterion<BoxedQueryRequest> criterion) {
        BoxedQueryRequest request = criterion.queryRequest();
        if (!window.end.equals(request.to())) {
            request.to(window.end);
        }
        if (request.from() == null) {
            request.from(window.begin);
            request.nextAfter(window.begin);
        }
    }

    private void setupWindowFromTail(Ordinal from) {
        BoxedQueryRequest request = this.criteria.get(1).queryRequest();
        if (!from.equals(request.from())) {
            request.from(from).nextAfter(from);
            if (this.until != null) {
                this.until.queryRequest().from(from).nextAfter(from);
            }
            for (int i = 2; i < this.maxStages; ++i) {
                BoxedQueryRequest subRequest = this.criteria.get(i).queryRequest();
                subRequest.from(null);
            }
        }
    }

    private void payload(ActionListener<Payload> listener) {
        List<Sequence> completed = this.matcher.completed();
        this.log.trace("Sending payload for [{}] sequences", (Object)completed.size());
        if (completed.isEmpty()) {
            listener.onResponse((Object)new EmptyPayload(Payload.Type.SEQUENCE, this.timeTook()));
            this.close(listener);
            return;
        }
        this.client.fetchHits(this.hits(completed), (ActionListener<List<List<SearchHit>>>)ActionListeners.map(listener, listOfHits -> {
            SequencePayload payload = new SequencePayload(completed, (List<List<SearchHit>>)listOfHits, false, this.timeTook());
            this.close(listener);
            return payload;
        }));
    }

    private void close(ActionListener<Payload> listener) {
        this.matcher.clear();
        this.client.close((ActionListener<Boolean>)ActionListener.delegateFailure(listener, (l, r) -> {}));
    }

    private TimeValue timeTook() {
        return new TimeValue(System.currentTimeMillis() - this.startTime);
    }

    private static Ordinal headOrdinal(List<SearchHit> hits, Criterion<BoxedQueryRequest> criterion) {
        return criterion.ordinal(hits.get(0));
    }

    private static Ordinal tailOrdinal(List<SearchHit> hits, Criterion<BoxedQueryRequest> criterion) {
        return criterion.ordinal(hits.get(hits.size() - 1));
    }

    Iterable<List<HitReference>> hits(List<Sequence> sequences) {
        return () -> {
            final Iterator<Object> delegate = this.criteria.get(0).descending() != this.criteria.get(1).descending() ? new ReversedIterator(sequences) : sequences.iterator();
            return new Iterator<List<HitReference>>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public List<HitReference> next() {
                    return ((Sequence)delegate.next()).hits();
                }
            };
        };
    }

    Iterable<Tuple<KeyAndOrdinal, HitReference>> wrapValues(final Criterion<?> criterion, List<SearchHit> hits) {
        return () -> {
            final Iterator<Object> delegate = criterion.descending() ? new ReversedIterator(hits) : hits.iterator();
            return new Iterator<Tuple<KeyAndOrdinal, HitReference>>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public Tuple<KeyAndOrdinal, HitReference> next() {
                    SearchHit hit = (SearchHit)delegate.next();
                    SequenceKey k = criterion.key(hit);
                    Ordinal o = criterion.ordinal(hit);
                    return new Tuple((Object)new KeyAndOrdinal(k, o), (Object)new HitReference(hit));
                }
            };
        };
    }

    <E> Iterable<KeyAndOrdinal> wrapUntilValues(Iterable<Tuple<KeyAndOrdinal, E>> iterable) {
        return () -> {
            final Iterator delegate = iterable.iterator();
            return new Iterator<KeyAndOrdinal>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public KeyAndOrdinal next() {
                    return (KeyAndOrdinal)((Tuple)delegate.next()).v1();
                }
            };
        };
    }

    private static class WindowInfo {
        private final int baseStage;
        private final Ordinal begin;
        private final Ordinal end;

        WindowInfo(int baseStage, Ordinal begin, Ordinal end) {
            this.baseStage = baseStage;
            this.begin = begin;
            this.end = end;
        }
    }
}

