/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;

class StageToKeys {
    private final List<Set<SequenceKey>> stageToKey;

    StageToKeys(int stages) {
        this.stageToKey = Arrays.asList(new Set[stages]);
    }

    void add(int stage, SequenceKey key) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        if (set == null) {
            set = new LinkedHashSet<SequenceKey>();
            this.stageToKey.set(stage, set);
        }
        set.add(key);
    }

    void remove(int stage, SequenceKey key) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        if (set != null) {
            set.remove(key);
        }
    }

    boolean isEmpty(int stage) {
        Set<SequenceKey> set = this.stageToKey.get(stage);
        return set == null || set.isEmpty();
    }

    void clear() {
        for (Set<SequenceKey> set : this.stageToKey) {
            if (set == null) continue;
            set.clear();
        }
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",", "[", "]");
        this.stageToKey.forEach(s -> sj.add(s != null ? "" + s.size() : "0"));
        return sj.toString();
    }
}

