/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search.extractor;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.execution.search.extractor.AbstractFieldHitExtractor;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;

public class FieldHitExtractor
extends AbstractFieldHitExtractor {
    static final String NAME = "f";

    public FieldHitExtractor(StreamInput in) throws IOException {
        super(in);
    }

    public FieldHitExtractor(String name, String fullFieldName, DataType dataType, ZoneId zoneId, boolean useDocValue, String hitName, boolean arrayLeniency) {
        super(name, fullFieldName, dataType, zoneId, useDocValue, hitName, arrayLeniency);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected ZoneId readZoneId(StreamInput in) throws IOException {
        return DateUtils.UTC;
    }

    protected Object unwrapCustomValue(Object values) {
        DataType dataType = this.dataType();
        if (dataType == DataTypes.DATETIME && values instanceof String) {
            return this.parseDateString(values);
        }
        return null;
    }

    protected Object parseDateString(Object values) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(values.toString())), this.zoneId());
    }

    protected boolean isPrimitive(List<?> list) {
        return false;
    }
}

