/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.extractor.FieldHitExtractor;
import org.elasticsearch.xpack.eql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.eql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.extractor.ComputingExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.HitExtractorInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.ReferenceInput;
import org.elasticsearch.xpack.ql.index.IndexResolver;

public final class RuntimeUtils {
    static final Logger QUERY_LOG = LogManager.getLogger(QueryClient.class);

    private RuntimeUtils() {
    }

    public static ActionListener<SearchResponse> searchLogListener(ActionListener<SearchResponse> listener, Logger log) {
        return ActionListener.wrap(response -> {
            Object[] failures = response.getShardFailures();
            if (!CollectionUtils.isEmpty((Object[])failures)) {
                listener.onFailure((Exception)((Object)new EqlIllegalArgumentException(failures[0].reason(), failures[0].getCause())));
                return;
            }
            if (log.isTraceEnabled()) {
                RuntimeUtils.logSearchResponse(response, log);
            }
            listener.onResponse(response);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public static ActionListener<MultiSearchResponse> multiSearchLogListener(ActionListener<MultiSearchResponse> listener, Logger log) {
        return ActionListener.wrap(items -> {
            for (MultiSearchResponse.Item item : items) {
                Object[] failures;
                Object failure = item.getFailure();
                SearchResponse response = item.getResponse();
                if (failure == null && !CollectionUtils.isEmpty((Object[])(failures = response.getShardFailures()))) {
                    failure = new EqlIllegalArgumentException(failures[0].reason(), failures[0].getCause());
                }
                if (failure != null) {
                    listener.onFailure(failure);
                    return;
                }
                if (!log.isTraceEnabled()) continue;
                RuntimeUtils.logSearchResponse(response, log);
            }
            listener.onResponse(items);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private static void logSearchResponse(SearchResponse response, Logger logger) {
        List aggs = Collections.emptyList();
        if (response.getAggregations() != null) {
            aggs = response.getAggregations().asList();
        }
        StringBuilder aggsNames = new StringBuilder();
        for (int i = 0; i < aggs.size(); ++i) {
            aggsNames.append(((Aggregation)aggs.get(i)).getName() + (i + 1 == aggs.size() ? "" : ", "));
        }
        SearchHit[] hits = response.getHits().getHits();
        int count = hits != null ? hits.length : 0;
        logger.trace("Got search response [hits {}, {} aggregations: [{}], {} failed shards, {} skipped shards, {} successful shards, {} total shards, took {}, timed out [{}]]", (Object)count, (Object)aggs.size(), (Object)aggsNames, (Object)response.getFailedShards(), (Object)response.getSkippedShards(), (Object)response.getSuccessfulShards(), (Object)response.getTotalShards(), (Object)response.getTook(), (Object)response.isTimedOut());
    }

    public static List<HitExtractor> createExtractor(List<FieldExtraction> fields, EqlConfiguration cfg) {
        ArrayList<HitExtractor> extractors = new ArrayList<HitExtractor>(fields.size());
        for (FieldExtraction fe : fields) {
            extractors.add(RuntimeUtils.createExtractor(fe, cfg));
        }
        return extractors;
    }

    public static HitExtractor createExtractor(FieldExtraction ref, EqlConfiguration cfg) {
        if (ref instanceof SearchHitFieldRef) {
            SearchHitFieldRef f = (SearchHitFieldRef)ref;
            return new FieldHitExtractor(f.name(), f.fullFieldName(), f.getDataType(), cfg.zoneId(), f.useDocValue(), f.hitName(), false);
        }
        if (ref instanceof ComputedRef) {
            Pipe proc = ((ComputedRef)ref).processor();
            LinkedHashSet hitNames = new LinkedHashSet();
            proc = (Pipe)proc.transformDown(l -> {
                HitExtractor he = RuntimeUtils.createExtractor((FieldExtraction)l.context(), cfg);
                hitNames.add(he.hitName());
                if (hitNames.size() > 1) {
                    throw new EqlIllegalArgumentException("Multi-level nested fields [{}] not supported yet", hitNames);
                }
                return new HitExtractorInput(l.source(), l.expression(), he);
            }, ReferenceInput.class);
            String hitName = null;
            if (hitNames.size() == 1) {
                hitName = (String)hitNames.iterator().next();
            }
            return new ComputingExtractor(proc.asProcessor(), hitName);
        }
        throw new EqlIllegalArgumentException("Unexpected value reference {}", ref.getClass());
    }

    public static SearchRequest prepareRequest(Client client, SearchSourceBuilder source, boolean includeFrozen, String ... indices) {
        return (SearchRequest)client.prepareSearch(indices).setSource(source).setAllowPartialSearchResults(false).setIndicesOptions(includeFrozen ? IndexResolver.FIELD_CAPS_FROZEN_INDICES_OPTIONS : IndexResolver.FIELD_CAPS_INDICES_OPTIONS).request();
    }

    public static List<SearchHit> searchHits(SearchResponse response) {
        return Arrays.asList(response.getHits().getHits());
    }

    public static SearchSourceBuilder addFilter(QueryBuilder filter, SearchSourceBuilder source) {
        BoolQueryBuilder bool = null;
        QueryBuilder query = source.query();
        if (query instanceof BoolQueryBuilder) {
            bool = (BoolQueryBuilder)query;
            if (filter != null && !bool.filter().contains(filter)) {
                bool.filter(filter);
            }
        } else {
            bool = QueryBuilders.boolQuery();
            if (query != null) {
                bool.filter(query);
            }
            if (filter != null) {
                bool.filter(filter);
            }
            source.query((QueryBuilder)bool);
        }
        return source;
    }
}

