/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.policy;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderConfiguration;

public class AutoscalingPolicy
extends AbstractDiffable<AutoscalingPolicy>
implements Diffable<AutoscalingPolicy>,
ToXContentObject {
    public static final String NAME = "autoscaling_policy";
    public static final ParseField DECIDERS_FIELD = new ParseField("deciders", new String[0]);
    private static final ConstructingObjectParser<AutoscalingPolicy, String> PARSER = new ConstructingObjectParser("autoscaling_policy", false, (c, name) -> {
        List deciders = (List)c[0];
        return new AutoscalingPolicy((String)name, (SortedMap<String, AutoscalingDeciderConfiguration>)new TreeMap<String, AutoscalingDeciderConfiguration>(deciders.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    });
    private final String name;
    private final SortedMap<String, AutoscalingDeciderConfiguration> deciders;

    public static AutoscalingPolicy parse(XContentParser parser, String name) {
        return (AutoscalingPolicy)((Object)PARSER.apply(parser, (Object)name));
    }

    public String name() {
        return this.name;
    }

    public SortedMap<String, AutoscalingDeciderConfiguration> deciders() {
        return this.deciders;
    }

    public AutoscalingPolicy(String name, SortedMap<String, AutoscalingDeciderConfiguration> deciders) {
        this.name = Objects.requireNonNull(name);
        this.deciders = Objects.requireNonNull(deciders);
    }

    public AutoscalingPolicy(StreamInput in) throws IOException {
        this.name = in.readString();
        this.deciders = new TreeMap(in.readNamedWriteableList(AutoscalingDeciderConfiguration.class).stream().collect(Collectors.toMap(AutoscalingDeciderConfiguration::name, Function.identity())));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeNamedWriteableList(Collections.unmodifiableList(this.deciders.values().stream().collect(Collectors.toList())));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(DECIDERS_FIELD.getPreferredName());
        for (Map.Entry<String, AutoscalingDeciderConfiguration> entry : this.deciders.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoscalingPolicy that = (AutoscalingPolicy)((Object)o);
        return this.name.equals(that.name) && this.deciders.equals(that.deciders);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.deciders);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> new AbstractMap.SimpleEntry<String, AutoscalingDeciderConfiguration>(n, (AutoscalingDeciderConfiguration)p.namedObject(AutoscalingDeciderConfiguration.class, n, null)), DECIDERS_FIELD);
    }
}

