/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecision;
import org.elasticsearch.xpack.autoscaling.decision.FixedAutoscalingDeciderConfiguration;

public class FixedAutoscalingDeciderService
implements AutoscalingDeciderService<FixedAutoscalingDeciderConfiguration> {
    @Inject
    public FixedAutoscalingDeciderService() {
    }

    @Override
    public String name() {
        return "fixed";
    }

    @Override
    public AutoscalingDecision scale(FixedAutoscalingDeciderConfiguration configuration, AutoscalingDeciderContext context) {
        int nodes = configuration.nodes() != null ? configuration.nodes() : 1;
        AutoscalingCapacity requiredCapacity = configuration.storage() != null || configuration.memory() != null ? AutoscalingCapacity.builder().tier(FixedAutoscalingDeciderService.tierCapacity(configuration.storage(), nodes), FixedAutoscalingDeciderService.tierCapacity(configuration.memory(), nodes)).node(configuration.storage(), configuration.memory()).build() : null;
        return new AutoscalingDecision(requiredCapacity, new FixedReason(configuration.storage(), configuration.memory(), nodes));
    }

    private static ByteSizeValue tierCapacity(ByteSizeValue nodeCapacity, int nodes) {
        if (nodeCapacity != null) {
            return new ByteSizeValue(nodeCapacity.getBytes() * (long)nodes);
        }
        return null;
    }

    public static class FixedReason
    implements AutoscalingDecision.Reason {
        private final ByteSizeValue storage;
        private final ByteSizeValue memory;
        private final int nodes;

        public FixedReason(ByteSizeValue storage, ByteSizeValue memory, int nodes) {
            this.storage = storage;
            this.memory = memory;
            this.nodes = nodes;
        }

        public FixedReason(StreamInput in) throws IOException {
            this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.nodes = in.readInt();
        }

        @Override
        public String summary() {
            return "fixed storage [" + this.storage + "] memory [" + this.memory + "] nodes [" + this.nodes + "]";
        }

        public String getWriteableName() {
            return "fixed";
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.storage);
            out.writeOptionalWriteable((Writeable)this.memory);
            out.writeInt(this.nodes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("storage", (ToXContent)this.storage);
            builder.field("memory", (ToXContent)this.memory);
            builder.field("nodes", this.nodes);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedReason that = (FixedReason)o;
            return this.nodes == that.nodes && Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.memory, this.nodes);
        }
    }
}

