/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecision;

public class AutoscalingDecisions
implements ToXContent,
Writeable {
    private final String tier;
    private final AutoscalingCapacity currentCapacity;
    private final SortedMap<String, AutoscalingDecision> decisions;

    public Map<String, AutoscalingDecision> decisions() {
        return this.decisions;
    }

    public AutoscalingDecisions(String tier, AutoscalingCapacity currentCapacity, SortedMap<String, AutoscalingDecision> decisions) {
        Objects.requireNonNull(tier);
        Objects.requireNonNull(currentCapacity);
        this.tier = tier;
        this.currentCapacity = currentCapacity;
        Objects.requireNonNull(decisions);
        if (decisions.isEmpty()) {
            throw new IllegalArgumentException("decisions can not be empty");
        }
        this.decisions = decisions;
    }

    public AutoscalingDecisions(StreamInput in) throws IOException {
        this.tier = in.readString();
        this.currentCapacity = new AutoscalingCapacity(in);
        this.decisions = new TreeMap<String, AutoscalingDecision>(in.readMap(StreamInput::readString, AutoscalingDecision::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.tier);
        this.currentCapacity.writeTo(out);
        out.writeMap(this.decisions, StreamOutput::writeString, (output, decision) -> decision.writeTo(output));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("tier", this.tier);
        AutoscalingCapacity requiredCapacity = this.requiredCapacity();
        if (requiredCapacity != null) {
            builder.field("required_capacity", (ToXContent)requiredCapacity);
        }
        builder.field("current_capacity", (ToXContent)this.currentCapacity);
        builder.startArray("decisions");
        for (Map.Entry<String, AutoscalingDecision> entry : this.decisions.entrySet()) {
            builder.startObject();
            builder.field("name", entry.getKey());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public AutoscalingCapacity requiredCapacity() {
        if (this.decisions.values().stream().map(AutoscalingDecision::requiredCapacity).anyMatch(Objects::isNull)) {
            return null;
        }
        Optional<AutoscalingCapacity> result = this.decisions.values().stream().map(AutoscalingDecision::requiredCapacity).reduce(AutoscalingCapacity::upperBound);
        assert (result.isPresent());
        return result.get();
    }

    public AutoscalingCapacity currentCapacity() {
        return this.currentCapacity;
    }

    public String tier() {
        return this.tier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingDecisions that = (AutoscalingDecisions)o;
        return this.tier.equals(that.tier) && this.currentCapacity.equals(that.currentCapacity) && this.decisions.equals(that.decisions);
    }

    public int hashCode() {
        return Objects.hash(this.tier, this.currentCapacity, this.decisions);
    }
}

