/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;

public class PutAutoscalingPolicyAction
extends ActionType<AcknowledgedResponse> {
    public static final PutAutoscalingPolicyAction INSTANCE = new PutAutoscalingPolicyAction();
    public static final String NAME = "cluster:admin/autoscaling/put_autoscaling_policy";

    private PutAutoscalingPolicyAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_autoscaling_policy_request", a -> new Request((AutoscalingPolicy)((Object)((Object)a[0]))));
        private final AutoscalingPolicy policy;

        public static Request parse(XContentParser parser, String name) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        public AutoscalingPolicy policy() {
            return this.policy;
        }

        public Request(AutoscalingPolicy policy) {
            this.policy = Objects.requireNonNull(policy);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.policy = new AutoscalingPolicy(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.policy.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.policy.equals((Object)request.policy);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.policy});
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), AutoscalingPolicy::parse, POLICY_FIELD);
        }
    }
}

