/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class StringUtils {
    public static final String EMPTY = "";
    public static final DateTimeFormatter ISO_DATE_WITH_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).appendOffsetId().toFormatter(Locale.ROOT);
    public static final DateTimeFormatter ISO_DATE_WITH_NANOS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).appendOffsetId().toFormatter(Locale.ROOT);
    public static final DateTimeFormatter ISO_TIME_WITH_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).appendOffsetId().toFormatter(Locale.ROOT);
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;

    private StringUtils() {
    }

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).format(ISO_DATE_WITH_MILLIS);
        }
        if (value instanceof OffsetTime) {
            return ((OffsetTime)value).format(ISO_TIME_WITH_MILLIS);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toInstant().toString();
        }
        if (value instanceof Period) {
            StringBuilder sb = new StringBuilder(7);
            Period p = (Period)value;
            if (p.isNegative()) {
                sb.append("-");
                p = p.negated();
            } else {
                sb.append("+");
            }
            sb.append(p.getYears());
            sb.append("-");
            sb.append(p.getMonths());
            return sb.toString();
        }
        if (value instanceof Duration) {
            StringBuilder sb = new StringBuilder(23);
            Duration d = (Duration)value;
            if (d.isNegative()) {
                sb.append("-");
                d = d.negated();
            } else {
                sb.append("+");
            }
            long durationInSec = d.getSeconds();
            sb.append(durationInSec / 86400L);
            sb.append(" ");
            sb.append(StringUtils.indent((durationInSec %= 86400L) / 3600L));
            sb.append(":");
            sb.append(StringUtils.indent((durationInSec %= 3600L) / 60L));
            sb.append(":");
            sb.append(StringUtils.indent(durationInSec %= 60L));
            sb.append(".");
            sb.append(TimeUnit.NANOSECONDS.toMillis(d.getNano()));
            return sb.toString();
        }
        return Objects.toString(value);
    }

    private static String indent(long timeUnit) {
        return timeUnit < 10L ? "0" + timeUnit : Long.toString(timeUnit);
    }
}

