/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;

public class TransportMountSearchableSnapshotAction
extends TransportMasterNodeAction<MountSearchableSnapshotRequest, RestoreSnapshotResponse> {
    private final Client client;
    private final RepositoriesService repositoriesService;
    private final XPackLicenseState licenseState;
    private final SystemIndices systemIndices;

    @Inject
    public TransportMountSearchableSnapshotAction(TransportService transportService, ClusterService clusterService, Client client, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState, SystemIndices systemIndices) {
        super("cluster:admin/snapshot/mount", transportService, clusterService, threadPool, actionFilters, MountSearchableSnapshotRequest::new, indexNameExpressionResolver);
        this.client = client;
        this.repositoriesService = repositoriesService;
        this.licenseState = Objects.requireNonNull(licenseState);
        this.systemIndices = Objects.requireNonNull(systemIndices);
    }

    protected String executor() {
        return "generic";
    }

    protected RestoreSnapshotResponse read(StreamInput in) throws IOException {
        return new RestoreSnapshotResponse(in);
    }

    protected ClusterBlockException checkBlock(MountSearchableSnapshotRequest request, ClusterState state) {
        return null;
    }

    private static Settings buildIndexSettings(String repoName, SnapshotId snapshotId, IndexId indexId) {
        return Settings.builder().put(SearchableSnapshots.SNAPSHOT_REPOSITORY_SETTING.getKey(), repoName).put(SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.getKey(), snapshotId.getName()).put(SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.getKey(), snapshotId.getUUID()).put(SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.getKey(), indexId.getName()).put(SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.getKey(), indexId.getId()).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), "snapshot").put(IndexMetadata.SETTING_BLOCKS_WRITE, true).put(ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.getKey(), "searchable_snapshot_allocator").put(IndexModule.INDEX_RECOVERY_TYPE_SETTING.getKey(), "snapshot_prewarm").build();
    }

    protected void masterOperation(MountSearchableSnapshotRequest request, ClusterState state, ActionListener<RestoreSnapshotResponse> listener) {
        SearchableSnapshots.ensureValidLicense(this.licenseState);
        String mountedIndexName = request.mountedIndexName();
        if (this.systemIndices.isSystemIndex(mountedIndexName)) {
            throw new ElasticsearchException("system index [{}] cannot be mounted as searchable snapshots", new Object[]{mountedIndexName});
        }
        String repoName = request.repositoryName();
        String snapName = request.snapshotName();
        String indexName = request.snapshotIndexName();
        Repository repository = this.repositoriesService.repository(repoName);
        StepListener repositoryDataListener = new StepListener();
        repository.getRepositoryData((ActionListener)repositoryDataListener);
        repositoryDataListener.whenComplete(repoData -> {
            Map indexIds = repoData.getIndices();
            if (!indexIds.containsKey(indexName)) {
                throw new IndexNotFoundException("index [" + indexName + "] not found in repository [" + repoName + "]");
            }
            IndexId indexId = (IndexId)indexIds.get(indexName);
            Optional<SnapshotId> matchingSnapshotId = repoData.getSnapshotIds().stream().filter(s -> snapName.equals(s.getName())).findFirst();
            if (!matchingSnapshotId.isPresent()) {
                throw new ElasticsearchException("snapshot [" + snapName + "] not found in repository [" + repoName + "]", new Object[0]);
            }
            SnapshotId snapshotId = matchingSnapshotId.get();
            String[] ignoreIndexSettings = Arrays.copyOf(request.ignoreIndexSettings(), request.ignoreIndexSettings().length + 1);
            ignoreIndexSettings[ignoreIndexSettings.length - 1] = "index.data_path";
            this.client.admin().cluster().restoreSnapshot(((RestoreSnapshotRequest)new RestoreSnapshotRequest(repoName, snapName).indices(new String[]{indexName}).renamePattern(".+").renameReplacement(mountedIndexName).indexSettings(Settings.builder().put("index.number_of_replicas", 0).put("index.auto_expand_replicas", false).put("index.routing.allocation.include._tier_preference", String.join((CharSequence)",", "data_cold", "data_warm", "data_hot")).put(request.indexSettings()).put(TransportMountSearchableSnapshotAction.buildIndexSettings(request.repositoryName(), snapshotId, indexId)).build()).ignoreIndexSettings(ignoreIndexSettings).includeGlobalState(false).includeAliases(false).waitForCompletion(request.waitForCompletion()).masterNodeTimeout(request.masterNodeTimeout())).snapshotUuid(snapshotId.getUUID()), listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

