/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;

public class SearchableSnapshotAllocator
implements ExistingShardsAllocator {
    public static final String ALLOCATOR_NAME = "searchable_snapshot_allocator";

    public void beforeAllocation(RoutingAllocation allocation) {
    }

    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
    }

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        AllocateUnassignedDecision allocateUnassignedDecision;
        if (shardRouting.primary() && (shardRouting.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE || shardRouting.recoverySource().getType() == RecoverySource.Type.EMPTY_STORE)) {
            Settings indexSettings = allocation.metadata().index(shardRouting.index()).getSettings();
            IndexId indexId = new IndexId((String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings));
            SnapshotId snapshotId = new SnapshotId((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexSettings), (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings));
            String repository = (String)SearchableSnapshots.SNAPSHOT_REPOSITORY_SETTING.get(indexSettings);
            Snapshot snapshot = new Snapshot(repository, snapshotId);
            shardRouting = unassignedAllocationHandler.updateUnassigned(shardRouting.unassignedInfo(), (RecoverySource)new RecoverySource.SnapshotRecoverySource("_no_api_", snapshot, Version.CURRENT, indexId), allocation.changes());
        }
        if ((allocateUnassignedDecision = this.decideAllocation(allocation, shardRouting)).isDecisionTaken() && allocateUnassignedDecision.getAllocationDecision() != AllocationDecision.YES) {
            unassignedAllocationHandler.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
        }
    }

    private AllocateUnassignedDecision decideAllocation(RoutingAllocation allocation, ShardRouting shardRouting) {
        assert (shardRouting.unassigned());
        assert (((String)ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get(allocation.metadata().getIndexSafe(shardRouting.index()).getSettings())).equals(ALLOCATOR_NAME));
        if (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && allocation.snapshotShardSizeInfo().getShardSize(shardRouting) == null) {
            return AllocateUnassignedDecision.no((UnassignedInfo.AllocationStatus)UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (shardRouting.unassigned());
        assert (routingAllocation.debugDecision());
        return this.decideAllocation(routingAllocation, shardRouting);
    }

    public void cleanCaches() {
    }

    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
    }

    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
    }

    public int getNumberOfInFlightFetches() {
        return 0;
    }
}

