/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.cache;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.blobstore.cache.BlobStoreCacheService;
import org.elasticsearch.blobstore.cache.CachedBlob;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.store.BaseSearchableSnapshotIndexInput;
import org.elasticsearch.index.store.IndexInputStats;
import org.elasticsearch.index.store.SearchableSnapshotDirectory;
import org.elasticsearch.index.store.cache.CacheFile;
import org.elasticsearch.index.store.cache.CacheKey;
import org.elasticsearch.index.store.checksum.ChecksumBlobContainerIndexInput;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsConstants;

public class CachedBlobContainerIndexInput
extends BaseSearchableSnapshotIndexInput {
    public static final IOContext CACHE_WARMING_CONTEXT = new IOContext();
    private static final Logger logger = LogManager.getLogger(CachedBlobContainerIndexInput.class);
    private static final int COPY_BUFFER_SIZE = ByteSizeUnit.KB.toIntBytes(8L);
    private final SearchableSnapshotDirectory directory;
    private final CacheFileReference cacheFileReference;
    private final int defaultRangeSize;
    private long lastReadPosition;
    private long lastSeekPosition;

    public CachedBlobContainerIndexInput(SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, int rangeSize) {
        this("CachedBlobContainerIndexInput(" + fileInfo.physicalName() + ")", directory, fileInfo, context, stats, 0L, fileInfo.length(), new CacheFileReference(directory, fileInfo.physicalName(), fileInfo.length()), rangeSize);
        assert (this.getBufferSize() <= BlobStoreCacheService.DEFAULT_CACHED_BLOB_SIZE);
        stats.incrementOpenCount();
    }

    private CachedBlobContainerIndexInput(String resourceDesc, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long length, CacheFileReference cacheFileReference, int rangeSize) {
        super(resourceDesc, directory.blobContainer(), fileInfo, context, stats, offset, length);
        this.directory = directory;
        this.cacheFileReference = cacheFileReference;
        this.lastReadPosition = this.offset;
        this.lastSeekPosition = this.offset;
        this.defaultRangeSize = rangeSize;
    }

    @Override
    public void innerClose() {
        if (!this.isClone) {
            this.cacheFileReference.releaseOnClose();
        }
    }

    private void ensureContext(Predicate<IOContext> predicate) throws IOException {
        if (!predicate.test(this.context)) {
            assert (false) : "this method should not be used with this context " + this.context;
            throw new IOException("Cannot read the index input using context [context=" + this.context + ", input=" + (Object)((Object)this) + ']');
        }
    }

    private long getDefaultRangeSize() {
        return this.context != CACHE_WARMING_CONTEXT ? (long)this.defaultRangeSize : this.fileInfo.partSize().getBytes();
    }

    private Tuple<Long, Long> computeRange(long position) {
        long rangeSize = this.getDefaultRangeSize();
        long start = position / rangeSize * rangeSize;
        long end = Math.min(start + rangeSize, this.fileInfo.length());
        return Tuple.tuple((Object)start, (Object)end);
    }

    private CacheFile getCacheFileSafe() throws Exception {
        CacheFile cacheFile = this.cacheFileReference.get();
        if (cacheFile == null) {
            throw new AlreadyClosedException("Failed to acquire a non-evicted cache file");
        }
        return cacheFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readInternal(ByteBuffer b) throws IOException {
        int length;
        long position;
        block18: {
            this.ensureContext(ctx -> ctx != CACHE_WARMING_CONTEXT);
            assert (CachedBlobContainerIndexInput.assertCurrentThreadIsNotCacheFetchAsync());
            position = this.getFilePointer() + this.offset;
            length = b.remaining();
            if (length == CodecUtil.footerLength() && !this.isClone && position == this.fileInfo.length() - (long)length) {
                if (this.readChecksumFromFileInfo(b)) {
                    logger.trace("read footer of file [{}] at position [{}], bypassing all caches", (Object)this.fileInfo.physicalName(), (Object)position);
                    return;
                }
                assert (b.remaining() == length);
            }
            logger.trace("readInternal: read [{}-{}] ([{}] bytes) from [{}]", (Object)position, (Object)(position + (long)length), (Object)length, (Object)this);
            try {
                Releasable onCacheFillComplete;
                Future<Integer> readFuture;
                Tuple indexCacheMiss;
                CacheFile cacheFile;
                block20: {
                    block19: {
                        boolean isStartOfFile;
                        cacheFile = this.getCacheFileSafe();
                        Future<Integer> waitingForRead = cacheFile.readIfAvailableOrPending((Tuple<Long, Long>)Tuple.tuple((Object)position, (Object)(position + (long)length)), channel -> {
                            int read = this.readCacheFile(channel, position, b);
                            assert (read == length) : read + " vs " + length;
                            return read;
                        });
                        if (waitingForRead != null) {
                            Integer read = waitingForRead.get();
                            assert (read == length);
                            this.readComplete(position, length);
                            return;
                        }
                        boolean canBeFullyCached = this.fileInfo.length() <= (long)(BlobStoreCacheService.DEFAULT_CACHED_BLOB_SIZE * 2);
                        boolean bl = isStartOfFile = position + (long)length <= (long)BlobStoreCacheService.DEFAULT_CACHED_BLOB_SIZE;
                        if (!canBeFullyCached && !isStartOfFile) break block19;
                        CachedBlob cachedBlob = this.directory.getCachedBlob(this.fileInfo.physicalName(), 0L, length);
                        if (cachedBlob == CachedBlob.CACHE_MISS || cachedBlob == CachedBlob.CACHE_NOT_READY) {
                            indexCacheMiss = canBeFullyCached ? Tuple.tuple((Object)0L, (Object)this.fileInfo.length()) : Tuple.tuple((Object)0L, (Object)BlobStoreCacheService.DEFAULT_CACHED_BLOB_SIZE);
                            break block20;
                        } else {
                            BytesRef bytesRef;
                            logger.trace("reading [{}] bytes of file [{}] at position [{}] using cache index", (Object)length, (Object)this.fileInfo.physicalName(), (Object)position);
                            this.stats.addIndexCacheBytesRead(cachedBlob.length());
                            BytesRefIterator cachedBytesIterator = cachedBlob.bytes().slice(SearchableSnapshotsConstants.toIntBytes((long)position), length).iterator();
                            while ((bytesRef = cachedBytesIterator.next()) != null) {
                                b.put(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                            }
                            assert (b.position() == length) : "copied " + b.position() + " but expected " + length;
                            try {
                                Tuple cachedRange = Tuple.tuple((Object)cachedBlob.from(), (Object)cachedBlob.to());
                                cacheFile.populateAndRead((Tuple<Long, Long>)cachedRange, (Tuple<Long, Long>)cachedRange, channel -> cachedBlob.length(), (channel, from, to, progressUpdater) -> {
                                    BytesRef current;
                                    long startTimeNanos = this.stats.currentTimeNanos();
                                    BytesRefIterator iterator = cachedBlob.bytes().slice(SearchableSnapshotsConstants.toIntBytes((long)(from - cachedBlob.from())), SearchableSnapshotsConstants.toIntBytes((long)(to - from))).iterator();
                                    long writePosition = from;
                                    while ((current = iterator.next()) != null) {
                                        ByteBuffer byteBuffer = ByteBuffer.wrap(current.bytes, current.offset, current.length);
                                        while (byteBuffer.remaining() > 0) {
                                            writePosition += (long)CachedBlobContainerIndexInput.positionalWrite(channel, writePosition, byteBuffer);
                                            progressUpdater.accept(writePosition);
                                        }
                                    }
                                    assert (writePosition == to) : writePosition + " vs " + to;
                                    long endTimeNanos = this.stats.currentTimeNanos();
                                    this.stats.addCachedBytesWritten(to - from, endTimeNanos - startTimeNanos);
                                    logger.trace("copied bytes [{}-{}] of file [{}] from cache index to disk", (Object)from, (Object)to, (Object)this.fileInfo);
                                }, this.directory.cacheFetchAsyncExecutor());
                            }
                            catch (Exception e) {
                                logger.debug((Message)new ParameterizedMessage("failed to store bytes [{}-{}] of file [{}] obtained from index cache", new Object[]{cachedBlob.from(), cachedBlob.to(), this.fileInfo}), (Throwable)e);
                            }
                            this.readComplete(position, length);
                            return;
                        }
                    }
                    indexCacheMiss = null;
                }
                Tuple<Long, Long> startRangeToWrite = this.computeRange(position);
                Tuple<Long, Long> endRangeToWrite = this.computeRange(position + (long)length - 1L);
                assert ((Long)startRangeToWrite.v2() <= (Long)endRangeToWrite.v2()) : startRangeToWrite + " vs " + endRangeToWrite;
                Tuple rangeToWrite = Tuple.tuple((Object)Math.min((Long)startRangeToWrite.v1(), indexCacheMiss == null ? Long.MAX_VALUE : (Long)indexCacheMiss.v1()), (Object)Math.max((Long)endRangeToWrite.v2(), indexCacheMiss == null ? Long.MIN_VALUE : (Long)indexCacheMiss.v2()));
                assert ((Long)rangeToWrite.v1() <= position && position + (long)length <= (Long)rangeToWrite.v2()) : "[" + position + "-" + (position + (long)length) + "] vs " + rangeToWrite;
                Tuple rangeToRead = Tuple.tuple((Object)position, (Object)(position + (long)length));
                Future<Integer> populateCacheFuture = cacheFile.populateAndRead((Tuple<Long, Long>)rangeToWrite, (Tuple<Long, Long>)rangeToRead, channel -> {
                    int read;
                    if ((Long)rangeToRead.v2() - (Long)rangeToRead.v1() < (long)b.remaining()) {
                        ByteBuffer duplicate = b.duplicate();
                        duplicate.limit(duplicate.position() + SearchableSnapshotsConstants.toIntBytes((long)((Long)rangeToRead.v2() - (Long)rangeToRead.v1())));
                        read = this.readCacheFile(channel, position, duplicate);
                        assert (duplicate.position() <= b.limit());
                        b.position(duplicate.position());
                    } else {
                        read = this.readCacheFile(channel, position, b);
                    }
                    return read;
                }, this::writeCacheFile, this.directory.cacheFetchAsyncExecutor());
                if (indexCacheMiss != null && (readFuture = cacheFile.readIfAvailableOrPending((Tuple<Long, Long>)indexCacheMiss, arg_0 -> this.lambda$readInternal$5(indexCacheMiss, onCacheFillComplete = this.stats.addIndexCacheFill(), arg_0))) == null) {
                    onCacheFillComplete.close();
                }
                int bytesRead = populateCacheFuture.get();
                assert (bytesRead == length) : bytesRead + " vs " + length;
            }
            catch (Exception e) {
                int alreadyRead = length - b.remaining();
                int bytesRead = this.readDirectlyIfAlreadyClosed(position + (long)alreadyRead, b, e);
                if ($assertionsDisabled || alreadyRead + bytesRead == length) break block18;
                throw new AssertionError((Object)(alreadyRead + " + " + bytesRead + " vs " + length));
            }
        }
        this.readComplete(position, length);
    }

    private void readComplete(long position, int length) {
        this.stats.incrementBytesRead(this.lastReadPosition, position, length);
        this.lastSeekPosition = this.lastReadPosition = position + (long)length;
    }

    private int readDirectlyIfAlreadyClosed(long position, ByteBuffer b, Exception e) throws IOException {
        if (e instanceof AlreadyClosedException || e.getCause() != null && e.getCause() instanceof AlreadyClosedException) {
            try {
                long length = b.remaining();
                byte[] copyBuffer = new byte[SearchableSnapshotsConstants.toIntBytes((long)Math.min((long)COPY_BUFFER_SIZE, length))];
                logger.trace(() -> new ParameterizedMessage("direct reading of range [{}-{}] for cache file [{}]", new Object[]{position, position + length, this.cacheFileReference}));
                int bytesCopied = 0;
                long startTimeNanos = this.stats.currentTimeNanos();
                try (InputStream input = this.openInputStreamFromBlobStore(position, length);){
                    long remaining = length;
                    while (remaining > 0L) {
                        int len = remaining < (long)copyBuffer.length ? (int)remaining : copyBuffer.length;
                        int bytesRead = input.read(copyBuffer, 0, len);
                        if (bytesRead == -1) {
                            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] ([%d] bytes remaining) from %s", position, position + length, remaining, this.cacheFileReference));
                        }
                        b.put(copyBuffer, 0, bytesRead);
                        bytesCopied += bytesRead;
                        assert ((remaining -= (long)bytesRead) == (long)b.remaining()) : remaining + " vs " + b.remaining();
                    }
                    long endTimeNanos = this.stats.currentTimeNanos();
                    this.stats.addDirectBytesRead(bytesCopied, endTimeNanos - startTimeNanos);
                }
                return bytesCopied;
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
        }
        throw new IOException("failed to read data from cache", e);
    }

    private boolean readChecksumFromFileInfo(ByteBuffer b) throws IOException {
        byte[] footer;
        assert (!this.isClone);
        try {
            footer = ChecksumBlobContainerIndexInput.checksumToBytesArray(this.fileInfo.checksum());
        }
        catch (NumberFormatException e) {
            footer = null;
        }
        if (footer == null) {
            return false;
        }
        b.put(footer);
        assert ((long)b.remaining() == 0L);
        return true;
    }

    public void prefetchPart(int part) throws IOException {
        this.ensureContext(ctx -> ctx == CACHE_WARMING_CONTEXT);
        if (part >= this.fileInfo.numberOfParts()) {
            throw new IllegalArgumentException("Unexpected part number [" + part + "]");
        }
        Tuple<Long, Long> partRange = this.computeRange(IntStream.range(0, part).mapToLong(arg_0 -> ((BlobStoreIndexShardSnapshot.FileInfo)this.fileInfo).partBytes(arg_0)).sum());
        assert (this.assertRangeIsAlignedWithPart(partRange));
        try {
            CacheFile cacheFile = this.getCacheFileSafe();
            Tuple<Long, Long> range = cacheFile.getAbsentRangeWithin((Long)partRange.v1(), (Long)partRange.v2());
            if (range == null) {
                logger.trace("prefetchPart: part [{}] bytes [{}-{}] is already fully available for cache file [{}]", (Object)part, partRange.v1(), partRange.v2(), (Object)this.cacheFileReference);
                return;
            }
            long rangeStart = (Long)range.v1();
            long rangeEnd = (Long)range.v2();
            long rangeLength = rangeEnd - rangeStart;
            logger.trace("prefetchPart: prewarming part [{}] bytes [{}-{}] by fetching bytes [{}-{}] for cache file [{}]", (Object)part, partRange.v1(), partRange.v2(), (Object)rangeStart, (Object)rangeEnd, (Object)this.cacheFileReference);
            byte[] copyBuffer = new byte[SearchableSnapshotsConstants.toIntBytes((long)Math.min((long)COPY_BUFFER_SIZE, rangeLength))];
            long totalBytesRead = 0L;
            AtomicLong totalBytesWritten = new AtomicLong();
            long startTimeNanos = this.stats.currentTimeNanos();
            try (InputStream input = this.openInputStreamFromBlobStore(rangeStart, rangeLength);){
                int bytesRead;
                for (long remainingBytes = rangeEnd - rangeStart; remainingBytes > 0L; remainingBytes -= (long)bytesRead) {
                    Tuple rangeToWrite;
                    assert (totalBytesRead + remainingBytes == rangeLength);
                    bytesRead = CachedBlobContainerIndexInput.readSafe(input, copyBuffer, rangeStart, rangeEnd, remainingBytes, this.cacheFileReference);
                    long readStart = rangeStart + totalBytesRead;
                    Tuple rangeToRead = rangeToWrite = Tuple.tuple((Object)readStart, (Object)(readStart + (long)bytesRead));
                    cacheFile.populateAndRead((Tuple<Long, Long>)rangeToWrite, (Tuple<Long, Long>)rangeToRead, channel -> bytesRead, (channel, start, end, progressUpdater) -> {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(copyBuffer, SearchableSnapshotsConstants.toIntBytes((long)(start - readStart)), SearchableSnapshotsConstants.toIntBytes((long)(end - start)));
                        int writtenBytes = CachedBlobContainerIndexInput.positionalWrite(channel, start, byteBuffer);
                        logger.trace("prefetchPart: writing range [{}-{}] of file [{}], [{}] bytes written", (Object)start, (Object)end, (Object)this.fileInfo.physicalName(), (Object)writtenBytes);
                        totalBytesWritten.addAndGet(writtenBytes);
                        progressUpdater.accept(start + (long)writtenBytes);
                    }, this.directory.cacheFetchAsyncExecutor()).get();
                    totalBytesRead += (long)bytesRead;
                }
                long endTimeNanos = this.stats.currentTimeNanos();
                this.stats.addCachedBytesWritten(totalBytesWritten.get(), endTimeNanos - startTimeNanos);
            }
            assert (totalBytesRead == rangeLength);
        }
        catch (Exception e) {
            throw new IOException("Failed to prefetch file part in cache", e);
        }
    }

    @SuppressForbidden(reason="Use positional writes on purpose")
    private static int positionalWrite(FileChannel fc, long start, ByteBuffer byteBuffer) throws IOException {
        assert (CachedBlobContainerIndexInput.assertCurrentThreadMayWriteCacheFile());
        return fc.write(byteBuffer, start);
    }

    private static int readSafe(InputStream inputStream, byte[] copyBuffer, long rangeStart, long rangeEnd, long remaining, CacheFileReference cacheFileReference) throws IOException {
        int len = remaining < (long)copyBuffer.length ? SearchableSnapshotsConstants.toIntBytes((long)remaining) : copyBuffer.length;
        int bytesRead = inputStream.read(copyBuffer, 0, len);
        if (bytesRead == -1) {
            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] ([%d] bytes remaining) from %s", rangeStart, rangeEnd, remaining, cacheFileReference));
        }
        assert (bytesRead > 0) : bytesRead;
        return bytesRead;
    }

    private boolean assertRangeIsAlignedWithPart(Tuple<Long, Long> range) {
        if ((long)this.fileInfo.numberOfParts() == 1L) {
            long length = this.fileInfo.length();
            assert ((Long)range.v1() == 0L) : "start of range [" + range.v1() + "] is not aligned with zero";
            assert ((Long)range.v2() == length) : "end of range [" + range.v2() + "] is not aligned with file length [" + length + ']';
        } else {
            long length = this.fileInfo.partSize().getBytes();
            assert ((Long)range.v1() % length == 0L) : "start of range [" + range.v1() + "] is not aligned with part start";
            assert ((Long)range.v2() % length == 0L || ((Long)range.v2()).longValue() == this.fileInfo.length()) : "end of range [" + range.v2() + "] is not aligned with part end or with file length";
        }
        return true;
    }

    private int readCacheFile(FileChannel fc, long position, ByteBuffer buffer) throws IOException {
        assert (CachedBlobContainerIndexInput.assertFileChannelOpen(fc));
        int bytesRead = Channels.readFromFileChannel((FileChannel)fc, (long)position, (ByteBuffer)buffer);
        if (bytesRead == -1) {
            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] from %s", position, position + (long)buffer.remaining(), this.cacheFileReference));
        }
        this.stats.addCachedBytesRead(bytesRead);
        return bytesRead;
    }

    private void writeCacheFile(FileChannel fc, long start, long end, Consumer<Long> progressUpdater) throws IOException {
        assert (CachedBlobContainerIndexInput.assertFileChannelOpen(fc));
        assert (CachedBlobContainerIndexInput.assertCurrentThreadMayWriteCacheFile());
        long length = end - start;
        byte[] copyBuffer = new byte[SearchableSnapshotsConstants.toIntBytes((long)Math.min((long)COPY_BUFFER_SIZE, length))];
        logger.trace(() -> new ParameterizedMessage("writing range [{}-{}] to cache file [{}]", new Object[]{start, end, this.cacheFileReference}));
        long bytesCopied = 0L;
        long startTimeNanos = this.stats.currentTimeNanos();
        try (InputStream input = this.openInputStreamFromBlobStore(start, length);){
            int bytesRead;
            for (long remaining = end - start; remaining > 0L; remaining -= (long)bytesRead) {
                bytesRead = CachedBlobContainerIndexInput.readSafe(input, copyBuffer, start, end, remaining, this.cacheFileReference);
                CachedBlobContainerIndexInput.positionalWrite(fc, start + bytesCopied, ByteBuffer.wrap(copyBuffer, 0, bytesRead));
                progressUpdater.accept(start + (bytesCopied += (long)bytesRead));
            }
            long endTimeNanos = this.stats.currentTimeNanos();
            this.stats.addCachedBytesWritten(bytesCopied, endTimeNanos - startTimeNanos);
        }
    }

    private InputStream openInputStreamFromBlobStore(final long position, final long length) throws IOException {
        assert (this.assertCurrentThreadMayAccessBlobStore());
        if ((long)this.fileInfo.numberOfParts() == 1L) {
            assert (position + length <= this.fileInfo.partBytes(0)) : "cannot read [" + position + "-" + (position + length) + "] from [" + this.fileInfo + "]";
            this.stats.addBlobStoreBytesRequested(length);
            return this.blobContainer.readBlob(this.fileInfo.partName(0), position, length);
        }
        final int startPart = this.getPartNumberForPosition(position);
        final int endPart = this.getPartNumberForPosition(position + length - 1L);
        for (int currentPart = startPart; currentPart <= endPart; ++currentPart) {
            long startInPart = currentPart == startPart ? this.getRelativePositionInPart(position) : 0L;
            long endInPart = currentPart == endPart ? this.getRelativePositionInPart(position + length - 1L) + 1L : this.getLengthOfPart(currentPart);
            this.stats.addBlobStoreBytesRequested(endInPart - startInPart);
        }
        return new SlicedInputStream(endPart - startPart + 1){

            protected InputStream openSlice(int slice) throws IOException {
                int currentPart = startPart + slice;
                long startInPart = currentPart == startPart ? CachedBlobContainerIndexInput.this.getRelativePositionInPart(position) : 0L;
                long endInPart = currentPart == endPart ? CachedBlobContainerIndexInput.this.getRelativePositionInPart(position + length - 1L) + 1L : CachedBlobContainerIndexInput.this.getLengthOfPart(currentPart);
                return CachedBlobContainerIndexInput.this.blobContainer.readBlob(CachedBlobContainerIndexInput.this.fileInfo.partName(currentPart), startInPart, endInPart - startInPart);
            }
        };
    }

    private int getPartNumberForPosition(long position) {
        this.ensureValidPosition(position);
        int part = Math.toIntExact(position / this.fileInfo.partSize().getBytes());
        assert (part <= this.fileInfo.numberOfParts()) : "part number [" + part + "] exceeds number of parts: " + this.fileInfo.numberOfParts();
        assert (part >= 0) : "part number [" + part + "] is negative";
        return part;
    }

    private long getRelativePositionInPart(long position) {
        this.ensureValidPosition(position);
        long pos = position % this.fileInfo.partSize().getBytes();
        assert (pos < this.fileInfo.partBytes(this.getPartNumberForPosition(pos))) : "position in part [" + pos + "] exceeds part's length";
        assert (pos >= 0L) : "position in part [" + pos + "] is negative";
        return pos;
    }

    private long getLengthOfPart(int part) {
        return this.fileInfo.partBytes(part);
    }

    private void ensureValidPosition(long position) {
        assert (position >= 0L && position < this.fileInfo.length()) : position + " vs " + this.fileInfo.length();
        if (position < 0L || position >= this.fileInfo.length()) {
            throw new IllegalArgumentException("Position [" + position + "] is invalid for a file of length [" + this.fileInfo.length() + "]");
        }
    }

    protected void seekInternal(long pos) throws IOException {
        if (pos > this.length()) {
            throw new EOFException("Reading past end of file [position=" + pos + ", length=" + this.length() + "] for " + this.toString());
        }
        if (pos < 0L) {
            throw new IOException("Seeking to negative position [" + pos + "] for " + this.toString());
        }
        long position = pos + this.offset;
        this.stats.incrementSeeks(this.lastSeekPosition, position);
        this.lastSeekPosition = position;
    }

    @Override
    public CachedBlobContainerIndexInput clone() {
        return (CachedBlobContainerIndexInput)super.clone();
    }

    public IndexInput slice(String sliceDescription, long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + (Object)((Object)this));
        }
        CachedBlobContainerIndexInput slice = new CachedBlobContainerIndexInput(this.getFullSliceDescription(sliceDescription), this.directory, this.fileInfo, this.context, this.stats, this.offset + offset, length, this.cacheFileReference, this.defaultRangeSize);
        slice.isClone = true;
        return slice;
    }

    public String toString() {
        return "CachedBlobContainerIndexInput{cacheFileReference=" + this.cacheFileReference + ", offset=" + this.offset + ", length=" + this.length() + ", position=" + this.getFilePointer() + ", rangeSize=" + this.getDefaultRangeSize() + ", directory=" + (Object)((Object)this.directory) + '}';
    }

    private static boolean assertFileChannelOpen(FileChannel fileChannel) {
        assert (fileChannel != null);
        assert (fileChannel.isOpen());
        return true;
    }

    private static boolean isCacheFetchAsyncThread(String threadName) {
        return threadName.contains("[searchable_snapshots_cache_fetch_async]");
    }

    private static boolean assertCurrentThreadMayWriteCacheFile() {
        String threadName = Thread.currentThread().getName();
        assert (CachedBlobContainerIndexInput.isCacheFetchAsyncThread(threadName)) : "expected the current thread [" + threadName + "] to belong to the cache fetch async thread pool";
        return true;
    }

    private static boolean assertCurrentThreadIsNotCacheFetchAsync() {
        String threadName = Thread.currentThread().getName();
        assert (!CachedBlobContainerIndexInput.isCacheFetchAsyncThread(threadName)) : "expected the current thread [" + threadName + "] to belong to the cache fetch async thread pool";
        return true;
    }

    private /* synthetic */ int lambda$readInternal$5(Tuple indexCacheMiss, final Releasable onCacheFillComplete, FileChannel channel) throws IOException {
        int indexCacheMissLength = SearchableSnapshotsConstants.toIntBytes((long)((Long)indexCacheMiss.v2() - (Long)indexCacheMiss.v1()));
        assert (indexCacheMissLength <= COPY_BUFFER_SIZE) : indexCacheMiss;
        ByteBuffer byteBuffer = ByteBuffer.allocate(indexCacheMissLength);
        Channels.readFromFileChannelWithEofException((FileChannel)channel, (long)((Long)indexCacheMiss.v1()), (ByteBuffer)byteBuffer);
        byteBuffer.flip();
        BytesReference content = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer);
        this.directory.putCachedBlob(this.fileInfo.physicalName(), (Long)indexCacheMiss.v1(), content, new ActionListener<Void>(){

            public void onResponse(Void response) {
                onCacheFillComplete.close();
            }

            public void onFailure(Exception e1) {
                onCacheFillComplete.close();
            }
        });
        return indexCacheMissLength;
    }

    private static class CacheFileReference
    implements CacheFile.EvictionListener {
        private final long fileLength;
        private final CacheKey cacheKey;
        private final SearchableSnapshotDirectory directory;
        private final AtomicReference<CacheFile> cacheFile = new AtomicReference();

        private CacheFileReference(SearchableSnapshotDirectory directory, String fileName, long fileLength) {
            this.cacheKey = directory.createCacheKey(fileName);
            this.fileLength = fileLength;
            this.directory = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        CacheFile get() throws Exception {
            CacheFile currentCacheFile = this.cacheFile.get();
            if (currentCacheFile != null) {
                return currentCacheFile;
            }
            CacheFile newCacheFile = this.directory.getCacheFile(this.cacheKey, this.fileLength);
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                currentCacheFile = this.cacheFile.get();
                if (currentCacheFile != null) {
                    return currentCacheFile;
                }
                if (newCacheFile.acquire(this)) {
                    CacheFile previousCacheFile = this.cacheFile.getAndSet(newCacheFile);
                    assert (previousCacheFile == null);
                    return newCacheFile;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEviction(CacheFile evictedCacheFile) {
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                if (this.cacheFile.compareAndSet(evictedCacheFile, null)) {
                    evictedCacheFile.release(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseOnClose() {
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                CacheFile currentCacheFile = this.cacheFile.getAndSet(null);
                if (currentCacheFile != null) {
                    currentCacheFile.release(this);
                }
            }
        }

        public String toString() {
            return "CacheFileReference{cacheKey='" + this.cacheKey + '\'' + ", fileLength=" + this.fileLength + ", acquired=" + (this.cacheFile.get() != null) + '}';
        }
    }
}

