/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.NumericTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SignificantTermsAggregatorFactory.class);
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final QueryBuilder backgroundFilter;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(SignificantTermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), SignificantTermsAggregatorFactory.bytesSupplier(), true);
        builder.register(SignificantTermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), SignificantTermsAggregatorFactory.numericSupplier(), true);
    }

    private static SignificantTermsAggregatorSupplier bytesSupplier() {
        return new SignificantTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                ExecutionMode execution = null;
                if (executionHint != null) {
                    execution = ExecutionMode.fromString(executionHint, deprecationLogger);
                }
                if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                    execution = ExecutionMode.MAP;
                }
                if (execution == null) {
                    execution = ExecutionMode.GLOBAL_ORDINALS;
                }
                if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
                }
                return execution.create(name, factories, valuesSource, format, bucketCountThresholds, includeExclude, context, parent, significanceHeuristic, lookup, cardinality, metadata);
            }
        };
    }

    private static SignificantTermsAggregatorSupplier numericSupplier() {
        return new SignificantTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                if (includeExclude != null && includeExclude.isRegexBased()) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
                }
                ValuesSource.Numeric numericValuesSource = (ValuesSource.Numeric)valuesSource;
                if (numericValuesSource.isFloatingPoint()) {
                    throw new UnsupportedOperationException("No support for examining floating point numerics");
                }
                IncludeExclude.LongFilter longFilter = null;
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToLongFilter(format);
                }
                return new NumericTermsAggregator(name, factories, agg -> {
                    NumericTermsAggregator numericTermsAggregator = agg;
                    Objects.requireNonNull(numericTermsAggregator);
                    return numericTermsAggregator.new NumericTermsAggregator.SignificantLongTermsResults(lookup, significanceHeuristic, cardinality);
                }, numericValuesSource, format, null, bucketCountThresholds, context, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, longFilter, cardinality, metadata);
            }
        };
    }

    SignificantTermsAggregatorFactory(String name, ValuesSourceConfig config, IncludeExclude includeExclude, String executionHint, QueryBuilder backgroundFilter, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        if (config.hasValues() && !config.fieldContext().fieldType().isSearchable()) {
            throw new IllegalArgumentException("SignificantText aggregation requires fields to be searchable, but [" + config.fieldContext().fieldType().name() + "] is not");
        }
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.backgroundFilter = backgroundFilter;
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        SignificantTermsAggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(SignificantTermsAggregationBuilder.REGISTRY_KEY, this.config);
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        SignificanceLookup lookup = new SignificanceLookup(this.queryShardContext, this.config.fieldContext().fieldType(), this.config.format(), this.backgroundFilter);
        return aggregatorSupplier.build(this.name, this.factories, this.config.getValuesSource(), this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, searchContext, parent, this.significanceHeuristic, lookup, cardinality, metadata);
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new MapStringTermsAggregator(name, factories, new MapStringTermsAggregator.ValuesSourceCollectorSource(valuesSource), a -> {
                    MapStringTermsAggregator mapStringTermsAggregator = a;
                    Objects.requireNonNull(mapStringTermsAggregator);
                    return new MapStringTermsAggregator.SignificantTermsResults(mapStringTermsAggregator, lookup, significanceHeuristic, cardinality);
                }, null, format, bucketCountThresholds, filter, aggregationContext, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificanceLookup lookup, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                boolean remapGlobalOrd = true;
                if (cardinality == CardinalityUpperBound.ONE && factories == AggregatorFactories.EMPTY && includeExclude == null) {
                    remapGlobalOrd = false;
                }
                return new GlobalOrdinalsStringTermsAggregator(name, factories, a -> {
                    GlobalOrdinalsStringTermsAggregator globalOrdinalsStringTermsAggregator = a;
                    Objects.requireNonNull(globalOrdinalsStringTermsAggregator);
                    return new GlobalOrdinalsStringTermsAggregator.SignificantTermsResults(globalOrdinalsStringTermsAggregator, lookup, significanceHeuristic, cardinality);
                }, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, null, format, bucketCountThresholds, filter, aggregationContext, parent, remapGlobalOrd, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, cardinality, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            if ("global_ordinals".equals(value)) {
                return GLOBAL_ORDINALS;
            }
            if ("global_ordinals_hash".equals(value)) {
                deprecationLogger.deprecate("global_ordinals_hash", "global_ordinals_hash is deprecated. Please use [global_ordinals] instead.", new Object[0]);
                return GLOBAL_ORDINALS;
            }
            if ("map".equals(value)) {
                return MAP;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, SearchContext var7, Aggregator var8, SignificanceHeuristic var9, SignificanceLookup var10, CardinalityUpperBound var11, Map<String, Object> var12) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

