/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.elasticsearch.action.resync.ResyncReplicationResponse;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.TransportService;

public class PrimaryReplicaSyncer {
    private static final Logger logger = LogManager.getLogger(PrimaryReplicaSyncer.class);
    private final TaskManager taskManager;
    private final SyncAction syncAction;
    public static final ByteSizeValue DEFAULT_CHUNK_SIZE = new ByteSizeValue(512L, ByteSizeUnit.KB);
    private volatile ByteSizeValue chunkSize = DEFAULT_CHUNK_SIZE;

    @Inject
    public PrimaryReplicaSyncer(TransportService transportService, TransportResyncReplicationAction syncAction) {
        this(transportService.getTaskManager(), (SyncAction)syncAction);
    }

    public PrimaryReplicaSyncer(TaskManager taskManager, SyncAction syncAction) {
        this.taskManager = taskManager;
        this.syncAction = syncAction;
    }

    void setChunkSize(ByteSizeValue chunkSize) {
        if (chunkSize.bytesAsInt() <= 0) {
            throw new IllegalArgumentException("chunkSize must be > 0");
        }
        this.chunkSize = chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resync(final IndexShard indexShard, final ActionListener<ResyncTask> listener) {
        Translog.Snapshot snapshot = null;
        try {
            long startingSeqNo = indexShard.getLastKnownGlobalCheckpoint() + 1L;
            long maxSeqNo = indexShard.seqNoStats().getMaxSeqNo();
            final ShardId shardId = indexShard.shardId();
            final Translog.Snapshot originalSnapshot = snapshot = indexShard.getHistoryOperations("resync", indexShard.indexSettings.isSoftDeleteEnabled() ? Engine.HistorySource.INDEX : Engine.HistorySource.TRANSLOG, startingSeqNo);
            final Translog.Snapshot wrappedSnapshot = new Translog.Snapshot(){

                @Override
                public synchronized void close() throws IOException {
                    originalSnapshot.close();
                }

                @Override
                public synchronized int totalOperations() {
                    return originalSnapshot.totalOperations();
                }

                @Override
                public synchronized Translog.Operation next() throws IOException {
                    IndexShardState state = indexShard.state();
                    if (state == IndexShardState.CLOSED) {
                        throw new IndexShardClosedException(shardId);
                    }
                    assert (state == IndexShardState.STARTED) : "resync should only happen on a started shard, but state was: " + (Object)((Object)state);
                    return originalSnapshot.next();
                }
            };
            ActionListener<ResyncTask> resyncListener = new ActionListener<ResyncTask>(){

                @Override
                public void onResponse(ResyncTask resyncTask) {
                    try {
                        wrappedSnapshot.close();
                        listener.onResponse(resyncTask);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        wrappedSnapshot.close();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    finally {
                        listener.onFailure(e);
                    }
                }
            };
            long maxSeenAutoIdTimestamp = indexShard.getMaxSeenAutoIdTimestamp();
            this.resync(shardId, indexShard.routingEntry().allocationId().getId(), indexShard.getPendingPrimaryTerm(), wrappedSnapshot, startingSeqNo, maxSeqNo, maxSeenAutoIdTimestamp, resyncListener);
        }
        catch (Exception e) {
            try {
                IOUtils.close(snapshot);
            }
            catch (IOException inner) {
                e.addSuppressed(inner);
            }
            finally {
                listener.onFailure(e);
            }
        }
    }

    private void resync(ShardId shardId, String primaryAllocationId, long primaryTerm, Translog.Snapshot snapshot, long startingSeqNo, long maxSeqNo, long maxSeenAutoIdTimestamp, final ActionListener<ResyncTask> listener) {
        ResyncRequest request = new ResyncRequest(shardId, primaryAllocationId);
        final ResyncTask resyncTask = (ResyncTask)this.taskManager.register("transport", "resync", request);
        ActionListener<Void> wrappedListener = new ActionListener<Void>(){

            @Override
            public void onResponse(Void ignore) {
                resyncTask.setPhase("finished");
                PrimaryReplicaSyncer.this.taskManager.unregister(resyncTask);
                listener.onResponse(resyncTask);
            }

            @Override
            public void onFailure(Exception e) {
                resyncTask.setPhase("finished");
                PrimaryReplicaSyncer.this.taskManager.unregister(resyncTask);
                listener.onFailure(e);
            }
        };
        try {
            new SnapshotSender(this.syncAction, resyncTask, shardId, primaryAllocationId, primaryTerm, snapshot, this.chunkSize.bytesAsInt(), startingSeqNo, maxSeqNo, maxSeenAutoIdTimestamp, wrappedListener).run();
        }
        catch (Exception e) {
            wrappedListener.onFailure(e);
        }
    }

    public static class ResyncTask
    extends Task {
        private volatile String phase = "starting";
        private volatile int totalOperations;
        private volatile int resyncedOperations;
        private volatile int skippedOperations;

        public ResyncTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
            super(id, type, action, description, parentTaskId, headers);
        }

        public void setPhase(String phase) {
            this.phase = phase;
        }

        public String getPhase() {
            return this.phase;
        }

        public int getTotalOperations() {
            return this.totalOperations;
        }

        public void setTotalOperations(int totalOperations) {
            this.totalOperations = totalOperations;
        }

        public int getResyncedOperations() {
            return this.resyncedOperations;
        }

        public void setResyncedOperations(int resyncedOperations) {
            this.resyncedOperations = resyncedOperations;
        }

        public int getSkippedOperations() {
            return this.skippedOperations;
        }

        public void setSkippedOperations(int skippedOperations) {
            this.skippedOperations = skippedOperations;
        }

        @Override
        public Status getStatus() {
            return new Status(this.phase, this.totalOperations, this.resyncedOperations, this.skippedOperations);
        }

        public static class Status
        implements Task.Status {
            public static final String NAME = "resync";
            private final String phase;
            private final int totalOperations;
            private final int resyncedOperations;
            private final int skippedOperations;

            public Status(StreamInput in) throws IOException {
                this.phase = in.readString();
                this.totalOperations = in.readVInt();
                this.resyncedOperations = in.readVInt();
                this.skippedOperations = in.readVInt();
            }

            public Status(String phase, int totalOperations, int resyncedOperations, int skippedOperations) {
                this.phase = Objects.requireNonNull(phase, "Phase cannot be null");
                this.totalOperations = totalOperations;
                this.resyncedOperations = resyncedOperations;
                this.skippedOperations = skippedOperations;
            }

            @Override
            public String getWriteableName() {
                return NAME;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("phase", this.phase);
                builder.field("totalOperations", this.totalOperations);
                builder.field("resyncedOperations", this.resyncedOperations);
                builder.field("skippedOperations", this.skippedOperations);
                builder.endObject();
                return builder;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.phase);
                out.writeVLong(this.totalOperations);
                out.writeVLong(this.resyncedOperations);
                out.writeVLong(this.skippedOperations);
            }

            public String toString() {
                return Strings.toString((ToXContent)this);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Status status = (Status)o;
                if (this.totalOperations != status.totalOperations) {
                    return false;
                }
                if (this.resyncedOperations != status.resyncedOperations) {
                    return false;
                }
                if (this.skippedOperations != status.skippedOperations) {
                    return false;
                }
                return this.phase.equals(status.phase);
            }

            public int hashCode() {
                int result = this.phase.hashCode();
                result = 31 * result + this.totalOperations;
                result = 31 * result + this.resyncedOperations;
                result = 31 * result + this.skippedOperations;
                return result;
            }
        }
    }

    public static class ResyncRequest
    extends ActionRequest {
        private final ShardId shardId;
        private final String allocationId;

        public ResyncRequest(ShardId shardId, String allocationId) {
            this.shardId = shardId;
            this.allocationId = allocationId;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ResyncTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "ResyncRequest{ " + this.shardId + ", " + this.allocationId + " }";
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }

    static class SnapshotSender
    extends AbstractRunnable
    implements ActionListener<ResyncReplicationResponse> {
        private final Logger logger;
        private final SyncAction syncAction;
        private final ResyncTask task;
        private final String primaryAllocationId;
        private final long primaryTerm;
        private final ShardId shardId;
        private final Translog.Snapshot snapshot;
        private final long startingSeqNo;
        private final long maxSeqNo;
        private final long maxSeenAutoIdTimestamp;
        private final int chunkSizeInBytes;
        private final ActionListener<Void> listener;
        private final AtomicBoolean firstMessage = new AtomicBoolean(true);
        private final AtomicInteger totalSentOps = new AtomicInteger();
        private final AtomicInteger totalSkippedOps = new AtomicInteger();
        private final AtomicBoolean closed = new AtomicBoolean();
        private static final Translog.Operation[] EMPTY_ARRAY = new Translog.Operation[0];

        SnapshotSender(SyncAction syncAction, ResyncTask task, ShardId shardId, String primaryAllocationId, long primaryTerm, Translog.Snapshot snapshot, int chunkSizeInBytes, long startingSeqNo, long maxSeqNo, long maxSeenAutoIdTimestamp, ActionListener<Void> listener) {
            this.logger = logger;
            this.syncAction = syncAction;
            this.task = task;
            this.shardId = shardId;
            this.primaryAllocationId = primaryAllocationId;
            this.primaryTerm = primaryTerm;
            this.snapshot = snapshot;
            this.chunkSizeInBytes = chunkSizeInBytes;
            this.startingSeqNo = startingSeqNo;
            this.maxSeqNo = maxSeqNo;
            this.maxSeenAutoIdTimestamp = maxSeenAutoIdTimestamp;
            this.listener = listener;
            task.setTotalOperations(snapshot.totalOperations());
        }

        @Override
        public void onResponse(ResyncReplicationResponse response) {
            this.run();
        }

        @Override
        public void onFailure(Exception e) {
            if (this.closed.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            }
        }

        @Override
        protected void doRun() throws Exception {
            long trimmedAboveSeqNo;
            Translog.Operation operation;
            long size = 0L;
            ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
            this.task.setPhase("collecting_ops");
            this.task.setResyncedOperations(this.totalSentOps.get());
            this.task.setSkippedOperations(this.totalSkippedOps.get());
            while ((operation = this.snapshot.next()) != null) {
                long seqNo = operation.seqNo();
                if (seqNo == -2L || seqNo < this.startingSeqNo) {
                    this.totalSkippedOps.incrementAndGet();
                    continue;
                }
                assert (operation.seqNo() >= 0L) : "sending operation with unassigned sequence number [" + operation + "]";
                operations.add(operation);
                this.totalSentOps.incrementAndGet();
                if ((size += operation.estimateSize()) < (long)this.chunkSizeInBytes) continue;
                break;
            }
            long l = trimmedAboveSeqNo = this.firstMessage.get() ? this.maxSeqNo : -2L;
            if (!operations.isEmpty() || trimmedAboveSeqNo != -2L) {
                this.task.setPhase("sending_ops");
                ResyncReplicationRequest request = new ResyncReplicationRequest(this.shardId, trimmedAboveSeqNo, this.maxSeenAutoIdTimestamp, operations.toArray(EMPTY_ARRAY));
                this.logger.trace("{} sending batch of [{}][{}] (total sent: [{}], skipped: [{}])", (Object)this.shardId, (Object)operations.size(), (Object)new ByteSizeValue(size), (Object)this.totalSentOps.get(), (Object)this.totalSkippedOps.get());
                this.firstMessage.set(false);
                this.syncAction.sync(request, this.task, this.primaryAllocationId, this.primaryTerm, this);
            } else if (this.closed.compareAndSet(false, true)) {
                this.logger.trace("{} resync completed (total sent: [{}], skipped: [{}])", (Object)this.shardId, (Object)this.totalSentOps.get(), (Object)this.totalSkippedOps.get());
                this.listener.onResponse(null);
            }
        }
    }

    public static interface SyncAction {
        public void sync(ResyncReplicationRequest var1, Task var2, String var3, long var4, ActionListener<ResyncReplicationResponse> var6);
    }
}

