/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class IpFieldMapper
extends ParametrizedFieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IpFieldMapper.class);
    public static final String CONTENT_TYPE = "ip";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final boolean ignoreMalformed;
    private final InetAddress nullValue;
    private final String nullValueAsString;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;

    private static IpFieldMapper toType(FieldMapper in) {
        return (IpFieldMapper)in;
    }

    private IpFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformedByDefault = builder.ignoreMalformedByDefault;
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.ignoreMalformed = (Boolean)builder.ignoreMalformed.getValue();
        this.nullValue = builder.parseNullValue();
        this.nullValueAsString = (String)builder.nullValue.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected IpFieldMapper clone() {
        return (IpFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        InetAddress address;
        Object addressAsObject = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (addressAsObject == null) {
            addressAsObject = this.nullValue;
        }
        if (addressAsObject == null) {
            return;
        }
        String addressAsString = addressAsObject.toString();
        if (addressAsObject instanceof InetAddress) {
            address = (InetAddress)addressAsObject;
        } else {
            try {
                address = InetAddresses.forString(addressAsString);
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.fieldType().name());
                    return;
                }
                throw e;
            }
        }
        if (this.indexed) {
            context.doc().add((IndexableField)new InetAddressPoint(this.fieldType().name(), address));
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else if (this.stored || this.indexed) {
            this.createFieldNamesField(context);
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        private final InetAddress nullValue;

        public IpFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, InetAddress nullValue, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
        }

        public IpFieldType(String name) {
            this(name, true, false, true, (InetAddress)null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private static InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), mapperService, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    InetAddress address = value instanceof InetAddress ? (InetAddress)value : InetAddresses.forString(value.toString());
                    return InetAddresses.toAddrString(address);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String term;
            this.failIfNotIndexed();
            if (value instanceof InetAddress) {
                return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            if ((term = value.toString()).contains("/")) {
                Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(term);
                return InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
            }
            InetAddress address = InetAddresses.forString(term);
            return InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            InetAddress[] addresses = new InetAddress[values.size()];
            int i = 0;
            for (Object value : values) {
                InetAddress address;
                if (value instanceof InetAddress) {
                    address = (InetAddress)value;
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    if (value.toString().contains("/")) {
                        return super.termsQuery(values, context);
                    }
                    address = InetAddresses.forString(value.toString());
                }
                addresses[i++] = address;
            }
            return InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])addresses);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            return IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper));
        }

        public static Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> builder) {
            InetAddress upper;
            InetAddress lower;
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = IpFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = IpFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return builder.apply(lower, upper);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), IpScriptDocValues::new, CoreValuesSourceType.IP);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.IP;
        }

        public static final class IpScriptDocValues
        extends ScriptDocValues<String> {
            private final SortedSetDocValues in;
            private long[] ords = new long[0];
            private int count;

            public IpScriptDocValues(SortedSetDocValues in) {
                this.in = in;
            }

            @Override
            public void setNextDocId(int docId) throws IOException {
                this.count = 0;
                if (this.in.advanceExact(docId)) {
                    long ord = this.in.nextOrd();
                    while (ord != -1L) {
                        this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                        this.ords[this.count++] = ord;
                        ord = this.in.nextOrd();
                    }
                }
            }

            public String getValue() {
                if (this.count == 0) {
                    return null;
                }
                return this.get(0);
            }

            @Override
            public String get(int index) {
                try {
                    BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                    InetAddress address = InetAddressPoint.decode((byte[])Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
                    return InetAddresses.toAddrString(address);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return this.count;
            }
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> IpFieldMapper.access$700(IpFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> IpFieldMapper.access$600(IpFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> IpFieldMapper.access$500(IpFieldMapper.toType(m)), false);
        private final ParametrizedFieldMapper.Parameter<Boolean> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<String> nullValue = ParametrizedFieldMapper.Parameter.stringParam("null_value", false, m -> IpFieldMapper.access$400(IpFieldMapper.toType(m)), null).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final boolean ignoreMalformedByDefault;
        private final Version indexCreatedVersion;

        public Builder(String name, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.ignoreMalformedByDefault = ignoreMalformedByDefault;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.boolParam("ignore_malformed", true, m -> IpFieldMapper.toType(m).ignoreMalformed, ignoreMalformedByDefault);
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        private InetAddress parseNullValue() {
            String nullValueAsString = this.nullValue.getValue();
            if (nullValueAsString == null) {
                return null;
            }
            try {
                return InetAddresses.forString(nullValueAsString);
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecate("ip_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as IP in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.meta);
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            return new IpFieldMapper(this.name, new IpFieldType(this.buildFullName(context), (boolean)this.indexed.getValue(), (boolean)this.stored.getValue(), (boolean)this.hasDocValues.getValue(), this.parseNullValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }
}

