/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.datastreams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.CreateDataStreamAction;
import org.elasticsearch.xpack.core.action.DataStreamsStatsAction;
import org.elasticsearch.xpack.core.action.DeleteDataStreamAction;
import org.elasticsearch.xpack.core.action.GetDataStreamAction;
import org.elasticsearch.xpack.datastreams.DataStreamFeatureSet;
import org.elasticsearch.xpack.datastreams.action.CreateDataStreamTransportAction;
import org.elasticsearch.xpack.datastreams.action.DataStreamsStatsTransportAction;
import org.elasticsearch.xpack.datastreams.action.DeleteDataStreamTransportAction;
import org.elasticsearch.xpack.datastreams.action.GetDataStreamsTransportAction;
import org.elasticsearch.xpack.datastreams.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.xpack.datastreams.rest.RestCreateDataStreamAction;
import org.elasticsearch.xpack.datastreams.rest.RestDataStreamsStatsAction;
import org.elasticsearch.xpack.datastreams.rest.RestDeleteDataStreamAction;
import org.elasticsearch.xpack.datastreams.rest.RestGetDataStreamsAction;

public class DataStreamsPlugin
extends Plugin
implements ActionPlugin,
MapperPlugin {
    private final boolean transportClientMode;

    public DataStreamsPlugin(Settings settings) {
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_data_stream_timestamp", DataStreamTimestampFieldMapper.PARSER);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)CreateDataStreamAction.INSTANCE, CreateDataStreamTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDataStreamAction.INSTANCE, DeleteDataStreamTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDataStreamAction.INSTANCE, GetDataStreamsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DataStreamsStatsAction.INSTANCE, DataStreamsStatsTransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestCreateDataStreamAction createDsAction = new RestCreateDataStreamAction();
        RestDeleteDataStreamAction deleteDsAction = new RestDeleteDataStreamAction();
        RestGetDataStreamsAction getDsAction = new RestGetDataStreamsAction();
        RestDataStreamsStatsAction dsStatsAction = new RestDataStreamsStatsAction();
        return Arrays.asList(new RestHandler[]{createDsAction, deleteDsAction, getDsAction, dsStatsAction});
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, DataStreamFeatureSet.class));
        return modules;
    }
}

