/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.watcher.notification.email.Authentication;
import org.elasticsearch.xpack.watcher.notification.email.Email;
import org.elasticsearch.xpack.watcher.notification.email.Profile;

public class Account {
    static final String SMTP_PROTOCOL = "smtp";
    public static final Setting<SecureString> SECURE_PASSWORD_SETTING = SecureSetting.secureString((String)"secure_password", null, (Setting.Property[])new Setting.Property[0]);
    static final Settings DEFAULT_SMTP_TIMEOUT_SETTINGS;
    private final Config config;
    private final CryptoService cryptoService;
    private final Logger logger;
    private final Session session;

    public static void init() {
    }

    Account(Config config, CryptoService cryptoService, Logger logger) {
        this.config = config;
        this.cryptoService = cryptoService;
        this.logger = logger;
        this.session = config.createSession();
    }

    public String name() {
        return this.config.name;
    }

    Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Email send(Email email, Authentication auth, Profile profile) throws MessagingException {
        InternetAddress localAddress;
        String user;
        email = this.config.defaults.apply(email);
        if (email.to == null) {
            throw new SettingsException("missing required email [to] field");
        }
        Transport transport = this.session.getTransport(SMTP_PROTOCOL);
        String string = user = auth != null ? auth.user() : this.config.smtp.user;
        if (user == null && (localAddress = InternetAddress.getLocalAddress((Session)this.session)) != null) {
            user = localAddress.getAddress();
        }
        String password = null;
        if (auth != null && auth.password() != null) {
            password = new String(auth.password().text(this.cryptoService));
        } else if (this.config.smtp.password != null) {
            password = new String(this.config.smtp.password.getChars());
        }
        if (profile == null) {
            profile = this.config.profile;
        }
        this.executeConnect(transport, user, password);
        ClassLoader contextClassLoader = null;
        try {
            SecurityManager sm;
            MimeMessage message = profile.toMimeMessage(email, this.session);
            String mid = message.getMessageID();
            message.saveChanges();
            if (mid != null) {
                message.setHeader("Message-ID", mid);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            if ((contextClassLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader())) != null) {
                this.setContextClassLoader(this.getClass().getClassLoader());
            }
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
        catch (Throwable throwable) {
            try {
                transport.close();
            }
            catch (MessagingException me) {
                this.logger.error("failed to close email transport for account [{}]", (Object)this.config.name);
            }
            if (contextClassLoader != null) {
                this.setContextClassLoader(contextClassLoader);
            }
            throw throwable;
        }
        try {
            transport.close();
        }
        catch (MessagingException me) {
            this.logger.error("failed to close email transport for account [{}]", (Object)this.config.name);
        }
        if (contextClassLoader != null) {
            this.setContextClassLoader(contextClassLoader);
        }
        return email;
    }

    private void executeConnect(Transport transport, String user, String password) throws MessagingException {
        SpecialPermission.check();
        try {
            AccessController.doPrivileged(() -> {
                transport.connect(this.config.smtp.host, this.config.smtp.port, user, password);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (MessagingException)e.getCause();
        }
    }

    private void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(classLoader);
            return null;
        });
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(() -> {
            MailcapCommandMap mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mailcap.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mailcap.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mailcap.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mailcap.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mailcap.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            CommandMap.setDefaultCommandMap((CommandMap)mailcap);
            return null;
        });
        DEFAULT_SMTP_TIMEOUT_SETTINGS = Settings.builder().put("connection_timeout", TimeValue.timeValueMinutes((long)2L)).put("write_timeout", TimeValue.timeValueMinutes((long)2L)).put("timeout", TimeValue.timeValueMinutes((long)2L)).build();
    }

    static class Config {
        static final String SMTP_SETTINGS_PREFIX = "mail.smtp.";
        final String name;
        final Profile profile;
        final Smtp smtp;
        final EmailDefaults defaults;

        Config(String name, Settings settings, @Nullable SSLSocketFactory sslSocketFactory, Logger logger) {
            this.name = name;
            this.profile = Profile.resolve(settings.get("profile"), Profile.STANDARD);
            this.defaults = new EmailDefaults(name, settings.getAsSettings("email_defaults"));
            this.smtp = new Smtp(settings.getAsSettings(Account.SMTP_PROTOCOL));
            if (this.smtp.host == null) {
                String msg = "missing required email account setting for account [" + name + "]. 'smtp.host' must be configured";
                throw new SettingsException(msg);
            }
            if (sslSocketFactory != null) {
                String sslKeys = this.smtp.properties.keySet().stream().map(String::valueOf).filter(key -> key.startsWith("mail.smtp.ssl.")).collect(Collectors.joining(","));
                if (!sslKeys.isEmpty()) {
                    logger.warn("The SMTP SSL settings [{}] that are configured for Account [{}] will be ignored due to the notification SSL settings in [{}]", (Object)sslKeys, (Object)name, (Object)"xpack.notification.email.ssl.");
                }
                this.smtp.setSocketFactory(sslSocketFactory);
            }
        }

        public Session createSession() {
            return Session.getInstance((Properties)this.smtp.properties);
        }

        static class EmailDefaults {
            final Email.Address from;
            final Email.AddressList replyTo;
            final Email.Priority priority;
            final Email.AddressList to;
            final Email.AddressList cc;
            final Email.AddressList bcc;
            final String subject;

            EmailDefaults(String accountName, Settings settings) {
                try {
                    this.from = Email.Address.parse(settings, Email.Field.FROM.getPreferredName());
                    this.replyTo = Email.AddressList.parse(settings, Email.Field.REPLY_TO.getPreferredName());
                    this.priority = Email.Priority.parse(settings, Email.Field.PRIORITY.getPreferredName());
                    this.to = Email.AddressList.parse(settings, Email.Field.TO.getPreferredName());
                    this.cc = Email.AddressList.parse(settings, Email.Field.CC.getPreferredName());
                    this.bcc = Email.AddressList.parse(settings, Email.Field.BCC.getPreferredName());
                    this.subject = settings.get(Email.Field.SUBJECT.getPreferredName());
                }
                catch (IllegalArgumentException iae) {
                    throw new SettingsException("invalid email defaults in email account settings [" + accountName + "]", (Throwable)iae);
                }
            }

            Email apply(Email email) {
                Email.Builder builder = Email.builder().copyFrom(email);
                if (email.from == null) {
                    builder.from(this.from);
                }
                if (email.replyTo == null) {
                    builder.replyTo(this.replyTo);
                }
                if (email.priority == null) {
                    builder.priority(this.priority);
                }
                if (email.to == null) {
                    builder.to(this.to);
                }
                if (email.cc == null) {
                    builder.cc(this.cc);
                }
                if (email.bcc == null) {
                    builder.bcc(this.bcc);
                }
                if (email.subject == null) {
                    builder.subject(this.subject);
                }
                return builder.build();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EmailDefaults that = (EmailDefaults)o;
                if (this.bcc != null ? !this.bcc.equals(that.bcc) : that.bcc != null) {
                    return false;
                }
                if (this.cc != null ? !this.cc.equals(that.cc) : that.cc != null) {
                    return false;
                }
                if (this.from != null ? !this.from.equals((Object)that.from) : that.from != null) {
                    return false;
                }
                if (this.priority != that.priority) {
                    return false;
                }
                if (this.replyTo != null ? !this.replyTo.equals(that.replyTo) : that.replyTo != null) {
                    return false;
                }
                if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) {
                    return false;
                }
                return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
            }

            public int hashCode() {
                int result = this.from != null ? this.from.hashCode() : 0;
                result = 31 * result + (this.replyTo != null ? this.replyTo.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
                result = 31 * result + (this.cc != null ? this.cc.hashCode() : 0);
                result = 31 * result + (this.bcc != null ? this.bcc.hashCode() : 0);
                result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
                return result;
            }
        }

        static class Smtp {
            final String host;
            final int port;
            final String user;
            final SecureString password;
            final Properties properties;

            Smtp(Settings settings) {
                this.host = settings.get("host", settings.get("localaddress", settings.get("local_address")));
                this.port = settings.getAsInt("port", settings.getAsInt("localport", settings.getAsInt("local_port", Integer.valueOf(25))));
                this.user = settings.get("user", settings.get("from", null));
                this.password = Smtp.getSecureSetting(settings, SECURE_PASSWORD_SETTING);
                this.properties = Smtp.loadSmtpProperties(settings);
            }

            private static SecureString getSecureSetting(Settings settings, Setting<SecureString> secureSetting) {
                SecureString secureString = (SecureString)secureSetting.get(settings);
                if (secureString != null && secureString.length() > 0) {
                    return secureString;
                }
                return null;
            }

            static Properties loadSmtpProperties(Settings settings) {
                Settings.Builder builder = Settings.builder().put(DEFAULT_SMTP_TIMEOUT_SETTINGS).put(settings);
                Smtp.replaceTimeValue(builder, "connection_timeout", "connectiontimeout");
                Smtp.replaceTimeValue(builder, "write_timeout", "writetimeout");
                Smtp.replaceTimeValue(builder, "timeout", "timeout");
                Smtp.replace(builder, "local_address", "localaddress");
                Smtp.replace(builder, "local_port", "localport");
                Smtp.replace(builder, "send_partial", "sendpartial");
                Smtp.replace(builder, "wait_on_quit", "quitwait");
                settings = builder.build();
                Properties props = new Properties();
                Set insecureSettings = settings.filter(s -> !s.startsWith("secure_")).keySet();
                for (String key : insecureSettings) {
                    props.setProperty(Config.SMTP_SETTINGS_PREFIX + key, settings.get(key));
                }
                return props;
            }

            static void replace(Settings.Builder settings, String currentKey, String newKey) {
                String value = settings.remove(currentKey);
                if (value != null) {
                    settings.put(newKey, value);
                }
            }

            static void replaceTimeValue(Settings.Builder settings, String currentKey, String newKey) {
                String value = settings.remove(currentKey);
                if (value != null) {
                    settings.put(newKey, TimeValue.parseTimeValue((String)value, (String)currentKey).millis());
                }
            }

            public void setSocketFactory(SocketFactory socketFactory) {
                this.properties.put("mail.smtp.ssl.socketFactory", socketFactory);
            }
        }
    }
}

