/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExporter;

public abstract class Exporter
implements AutoCloseable {
    public static Setting.AffixSettingDependency TYPE_DEPENDENCY = () -> TYPE_SETTING;
    private static final Setting.AffixSetting<Boolean> ENABLED_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<String> TYPE_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"type", key -> Setting.simpleString((String)key, (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings) {
            switch (value) {
                case "": {
                    break;
                }
                case "http": {
                    String namespace = TYPE_SETTING.getNamespace(TYPE_SETTING.getConcreteSetting(key));
                    Setting hostsSetting = HttpExporter.HOST_SETTING.getConcreteSettingForNamespace(namespace);
                    List hosts = (List)settings.get(hostsSetting);
                    if (!hosts.isEmpty()) break;
                    throw new SettingsException("host list for [" + hostsSetting.getKey() + "] is empty");
                }
                case "local": {
                    break;
                }
                default: {
                    throw new SettingsException("type [" + value + "] for key [" + key + "] is invalid, only [http] and [local] are allowed");
                }
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = TYPE_SETTING.getNamespace(TYPE_SETTING.getConcreteSetting(key));
            List<Setting> settings = Collections.singletonList(HttpExporter.HOST_SETTING.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> USE_INGEST_PIPELINE_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"use_ingest", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Boolean> CLUSTER_ALERTS_MANAGEMENT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"cluster_alerts.management.enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<List<String>> CLUSTER_ALERTS_BLACKLIST_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"cluster_alerts.management.blacklist", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    static final Setting.AffixSetting<DateFormatter> INDEX_NAME_TIME_FORMAT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.name.time_format", key -> new Setting(key, INDEX_FORMAT, DateFormatter::forPattern, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    private static final String INDEX_FORMAT = "yyyy.MM.dd";
    protected final Config config;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public Exporter(Config config) {
        this.config = config;
    }

    public String name() {
        return this.config.name;
    }

    public Config config() {
        return this.config;
    }

    public boolean isSingleton() {
        return false;
    }

    public abstract void openBulk(ActionListener<ExportBulk> var1);

    protected final boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected abstract void doClose();

    protected static DateFormatter dateTimeFormatter(Config config) {
        Setting setting = INDEX_NAME_TIME_FORMAT_SETTING.getConcreteSettingForNamespace(config.name);
        return (DateFormatter)setting.get(config.settings());
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        return Arrays.asList(USE_INGEST_PIPELINE_SETTING, CLUSTER_ALERTS_MANAGEMENT_SETTING, TYPE_SETTING, ENABLED_SETTING, INDEX_NAME_TIME_FORMAT_SETTING, CLUSTER_ALERTS_BLACKLIST_SETTING);
    }

    public static interface Factory {
        public Exporter create(Config var1);
    }

    public static class Config {
        private final String name;
        private final String type;
        private final boolean enabled;
        private final Settings settings;
        private final ClusterService clusterService;
        private final XPackLicenseState licenseState;

        public Config(String name, String type, Settings settings, ClusterService clusterService, XPackLicenseState licenseState) {
            this.name = name;
            this.type = type;
            this.settings = settings;
            this.clusterService = clusterService;
            this.licenseState = licenseState;
            this.enabled = (Boolean)ENABLED_SETTING.getConcreteSettingForNamespace(name).get(settings);
        }

        public String name() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Settings settings() {
            return this.settings;
        }

        public ClusterService clusterService() {
            return this.clusterService;
        }

        public XPackLicenseState licenseState() {
            return this.licenseState;
        }
    }
}

