/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.tools.java_version_checker.JavaVersion;
import org.elasticsearch.tools.launchers.JvmErgonomics;
import org.elasticsearch.tools.launchers.Launchers;
import org.elasticsearch.tools.launchers.SystemJvmOptions;

final class JvmOptionsParser {
    private static final Pattern PATTERN = Pattern.compile("((?<start>\\d+)(?<range>-)?(?<end>\\d+)?:)?(?<option>-.*)$");

    JvmOptionsParser() {
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length != 1) {
            throw new IllegalArgumentException("expected one argument specifying path to ES_PATH_CONF but was " + Arrays.toString(args));
        }
        JvmOptionsParser parser = new JvmOptionsParser();
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("ES_TMPDIR", System.getenv("ES_TMPDIR"));
        String environmentPathConf = System.getenv("ES_PATH_CONF");
        if (environmentPathConf != null) {
            substitutions.put("ES_PATH_CONF", environmentPathConf);
        }
        try {
            List<String> jvmOptions = parser.jvmOptions(Paths.get(args[0], new String[0]), System.getenv("ES_JAVA_OPTS"), substitutions);
            Launchers.outPrintln(String.join((CharSequence)" ", jvmOptions));
        }
        catch (JvmOptionsFileParserException e) {
            String errorMessage = String.format(Locale.ROOT, "encountered [%d] error%s parsing [%s]", e.invalidLines().size(), e.invalidLines().size() == 1 ? "" : "s", e.jvmOptionsFile());
            Launchers.errPrintln(errorMessage);
            int count = 0;
            for (Map.Entry<Integer, String> entry : e.invalidLines().entrySet()) {
                String message = String.format(Locale.ROOT, "[%d]: encountered improperly formatted JVM option in [%s] on line number [%d]: [%s]", ++count, e.jvmOptionsFile(), entry.getKey(), entry.getValue());
                Launchers.errPrintln(message);
            }
            Launchers.exit(1);
        }
        Launchers.exit(0);
    }

    private List<String> jvmOptions(Path config, String esJavaOpts, Map<String, String> substitutions) throws InterruptedException, IOException, JvmOptionsFileParserException {
        List<String> jvmOptions = this.readJvmOptionsFiles(config);
        if (esJavaOpts != null) {
            jvmOptions.addAll(Arrays.stream(esJavaOpts.split("\\s+")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList()));
        }
        List<String> substitutedJvmOptions = JvmOptionsParser.substitutePlaceholders(jvmOptions, Collections.unmodifiableMap(substitutions));
        List<String> ergonomicJvmOptions = JvmErgonomics.choose(substitutedJvmOptions);
        List<String> systemJvmOptions = SystemJvmOptions.systemJvmOptions();
        ArrayList<String> finalJvmOptions = new ArrayList<String>(systemJvmOptions.size() + substitutedJvmOptions.size() + ergonomicJvmOptions.size());
        finalJvmOptions.addAll(systemJvmOptions);
        finalJvmOptions.addAll(substitutedJvmOptions);
        finalJvmOptions.addAll(ergonomicJvmOptions);
        return finalJvmOptions;
    }

    List<String> readJvmOptionsFiles(Path config) throws IOException, JvmOptionsFileParserException {
        ArrayList<Path> jvmOptionsFiles = new ArrayList<Path>();
        jvmOptionsFiles.add(config.resolve("jvm.options"));
        Path jvmOptionsDirectory = config.resolve("jvm.options.d");
        if (Files.isDirectory(jvmOptionsDirectory, new LinkOption[0])) {
            try (DirectoryStream<Path> jvmOptionsDirectoryStream = Files.newDirectoryStream(config.resolve("jvm.options.d"), "*.options");){
                StreamSupport.stream(jvmOptionsDirectoryStream.spliterator(), false).sorted().forEach(jvmOptionsFiles::add);
            }
        }
        ArrayList<String> jvmOptions = new ArrayList<String>();
        for (Path jvmOptionsFile : jvmOptionsFiles) {
            TreeMap<Integer, String> invalidLines = new TreeMap<Integer, String>();
            try (InputStream is = Files.newInputStream(jvmOptionsFile, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(reader);){
                JvmOptionsParser.parse(JavaVersion.majorVersion((List)JavaVersion.CURRENT), br, jvmOptions::add, invalidLines::put);
            }
            if (invalidLines.isEmpty()) continue;
            throw new JvmOptionsFileParserException(jvmOptionsFile, invalidLines);
        }
        return jvmOptions;
    }

    static List<String> substitutePlaceholders(List<String> jvmOptions, Map<String, String> substitutions) {
        Map<String, String> placeholderSubstitutions = substitutions.entrySet().stream().collect(Collectors.toMap(e -> "${" + (String)e.getKey() + "}", Map.Entry::getValue));
        return jvmOptions.stream().map(jvmOption -> {
            String actualJvmOption = jvmOption;
            int start = jvmOption.indexOf("${");
            if (start >= 0 && jvmOption.indexOf(125, start) > 0) {
                for (Map.Entry placeholderSubstitution : placeholderSubstitutions.entrySet()) {
                    actualJvmOption = actualJvmOption.replace((CharSequence)placeholderSubstitution.getKey(), (CharSequence)placeholderSubstitution.getValue());
                }
            }
            return actualJvmOption;
        }).collect(Collectors.toList());
    }

    static void parse(int javaMajorVersion, BufferedReader br, JvmOptionConsumer jvmOptionConsumer, InvalidLineConsumer invalidLineConsumer) throws IOException {
        int lineNumber = 0;
        while (true) {
            String line = br.readLine();
            ++lineNumber;
            if (line == null) break;
            if (line.startsWith("#") || line.matches("\\s*")) continue;
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                int upper;
                int lower;
                String start = matcher.group("start");
                String end = matcher.group("end");
                if (start == null) {
                    jvmOptionConsumer.accept(line);
                    continue;
                }
                try {
                    lower = Integer.parseInt(start);
                }
                catch (NumberFormatException e) {
                    invalidLineConsumer.accept(lineNumber, line);
                    continue;
                }
                if (matcher.group("range") == null) {
                    upper = lower;
                } else if (end == null) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(end);
                    }
                    catch (NumberFormatException e) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                    if (upper < lower) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                }
                if (lower > javaMajorVersion || javaMajorVersion > upper) continue;
                jvmOptionConsumer.accept(matcher.group("option"));
                continue;
            }
            invalidLineConsumer.accept(lineNumber, line);
        }
    }

    static interface InvalidLineConsumer {
        public void accept(int var1, String var2);
    }

    static interface JvmOptionConsumer {
        public void accept(String var1);
    }

    static class JvmOptionsFileParserException
    extends Exception {
        private final Path jvmOptionsFile;
        private final SortedMap<Integer, String> invalidLines;

        Path jvmOptionsFile() {
            return this.jvmOptionsFile;
        }

        SortedMap<Integer, String> invalidLines() {
            return this.invalidLines;
        }

        JvmOptionsFileParserException(Path jvmOptionsFile, SortedMap<Integer, String> invalidLines) {
            this.jvmOptionsFile = jvmOptionsFile;
            this.invalidLines = invalidLines;
        }
    }
}

