/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.CappedScoreQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;

public class PinnedQueryBuilder
extends AbstractQueryBuilder<PinnedQueryBuilder> {
    public static final String NAME = "pinned";
    public static final int MAX_NUM_PINNED_HITS = 100;
    private static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    public static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);
    private final List<String> ids;
    private QueryBuilder organicQuery;
    private static final float MAX_ORGANIC_SCORE = Float.intBitsToFloat(0x7F000000) - 1.0f;
    private static final ConstructingObjectParser<PinnedQueryBuilder, Void> PARSER = new ConstructingObjectParser("pinned", a -> {
        QueryBuilder organicQuery = (QueryBuilder)a[0];
        List ids = (List)a[1];
        return new PinnedQueryBuilder(organicQuery, ids.toArray(new String[0]));
    });

    public PinnedQueryBuilder(QueryBuilder organicQuery, String ... ids) {
        if (organicQuery == null) {
            throw new IllegalArgumentException("[pinned] organicQuery cannot be null");
        }
        this.organicQuery = organicQuery;
        if (ids == null) {
            throw new IllegalArgumentException("[pinned] ids cannot be null");
        }
        if (ids.length > 100) {
            throw new IllegalArgumentException("[pinned] Max of 100 ids exceeded: " + ids.length + " provided.");
        }
        LinkedHashSet<String> deduped = new LinkedHashSet<String>();
        for (String id : ids) {
            if (id == null) {
                throw new IllegalArgumentException("[pinned] id cannot be null");
            }
            if (deduped.add(id)) continue;
            throw new IllegalArgumentException("[pinned] duplicate id found in list: " + id);
        }
        this.ids = new ArrayList<String>();
        Collections.addAll(this.ids, ids);
    }

    public PinnedQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.ids = in.readStringList();
        this.organicQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.ids);
        out.writeNamedWriteable((NamedWriteable)this.organicQuery);
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    public List<String> ids() {
        return Collections.unmodifiableList(this.ids);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.organicQuery != null) {
            builder.field(ORGANIC_QUERY_FIELD.getPreferredName());
            this.organicQuery.toXContent(builder, params);
        }
        builder.startArray(IDS_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static PinnedQueryBuilder fromXContent(XContentParser parser) {
        try {
            return (PinnedQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder newOrganicQuery = this.organicQuery.rewrite(queryShardContext);
        if (newOrganicQuery != this.organicQuery) {
            PinnedQueryBuilder result = new PinnedQueryBuilder(newOrganicQuery, this.ids.toArray(new String[0]));
            result.boost(this.boost);
            return result;
        }
        return this;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType idField = context.fieldMapper("_id");
        if (idField == null) {
            return new MatchNoDocsQuery("No mappings");
        }
        if (this.ids.isEmpty()) {
            return new CappedScoreQuery(this.organicQuery.toQuery(context), MAX_ORGANIC_SCORE);
        }
        BooleanQuery.Builder pinnedQueries = new BooleanQuery.Builder();
        int minPin = NumericUtils.floatToSortableInt((float)MAX_ORGANIC_SCORE) + 1;
        int boostNum = minPin + this.ids.size();
        float lastScore = Float.MAX_VALUE;
        for (String id : this.ids) {
            float pinScore = NumericUtils.sortableIntToFloat((int)boostNum);
            assert (pinScore < lastScore);
            lastScore = pinScore;
            --boostNum;
            BoostQuery idQuery = new BoostQuery((Query)new ConstantScoreQuery(idField.termQuery((Object)id, context)), pinScore);
            pinnedQueries.add((Query)idQuery, BooleanClause.Occur.SHOULD);
        }
        ArrayList<Object> organicAndPinned = new ArrayList<Object>();
        organicAndPinned.add(pinnedQueries.build());
        organicAndPinned.add((Object)new CappedScoreQuery(this.organicQuery.toQuery(context), MAX_ORGANIC_SCORE));
        return new DisjunctionMaxQuery(organicAndPinned, 0.0f);
    }

    protected int doHashCode() {
        return Objects.hash(this.ids, this.organicQuery);
    }

    protected boolean doEquals(PinnedQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.organicQuery, other.organicQuery) && this.boost == other.boost;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PinnedQueryBuilder.parseInnerQueryBuilder((XContentParser)p), ORGANIC_QUERY_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), IDS_FIELD);
        PinnedQueryBuilder.declareStandardFields(PARSER);
    }
}

