/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.execute;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.client.WatchSourceBuilder;
import org.elasticsearch.xpack.core.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;

public class ExecuteWatchRequest
extends ActionRequest {
    public static final String INLINE_WATCH_ID = "_inlined_";
    private String id;
    private boolean ignoreCondition = false;
    private boolean recordExecution = false;
    @Nullable
    private Map<String, Object> triggerData = null;
    @Nullable
    private Map<String, Object> alternativeInput = null;
    private Map<String, ActionExecutionMode> actionModes = new HashMap<String, ActionExecutionMode>();
    private BytesReference watchSource;
    private XContentType xContentType = XContentType.JSON;
    private boolean debug = false;

    public ExecuteWatchRequest() {
    }

    public ExecuteWatchRequest(String id) {
        this.id = id;
    }

    public ExecuteWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.ignoreCondition = in.readBoolean();
        this.recordExecution = in.readBoolean();
        if (in.readBoolean()) {
            this.alternativeInput = in.readMap();
        }
        if (in.readBoolean()) {
            this.triggerData = in.readMap();
        }
        long actionModesCount = in.readLong();
        this.actionModes = new HashMap<String, ActionExecutionMode>();
        int i = 0;
        while ((long)i < actionModesCount) {
            this.actionModes.put(in.readString(), ActionExecutionMode.resolve(in.readByte()));
            ++i;
        }
        if (in.readBoolean()) {
            this.watchSource = in.readBytesReference();
            this.xContentType = (XContentType)in.readEnum(XContentType.class);
        }
        this.debug = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBoolean(this.ignoreCondition);
        out.writeBoolean(this.recordExecution);
        out.writeBoolean(this.alternativeInput != null);
        if (this.alternativeInput != null) {
            out.writeMap(this.alternativeInput);
        }
        out.writeBoolean(this.triggerData != null);
        if (this.triggerData != null) {
            out.writeMap(this.triggerData);
        }
        out.writeLong((long)this.actionModes.size());
        for (Map.Entry<String, ActionExecutionMode> entry : this.actionModes.entrySet()) {
            out.writeString(entry.getKey());
            out.writeByte(entry.getValue().id());
        }
        out.writeBoolean(this.watchSource != null);
        if (this.watchSource != null) {
            out.writeBytesReference(this.watchSource);
            out.writeEnum((Enum)this.xContentType);
        }
        out.writeBoolean(this.debug);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isIgnoreCondition() {
        return this.ignoreCondition;
    }

    public void setIgnoreCondition(boolean ignoreCondition) {
        this.ignoreCondition = ignoreCondition;
    }

    public boolean isRecordExecution() {
        return this.recordExecution;
    }

    public void setRecordExecution(boolean recordExecution) {
        this.recordExecution = recordExecution;
    }

    public Map<String, Object> getAlternativeInput() {
        return this.alternativeInput;
    }

    public void setAlternativeInput(Map<String, Object> alternativeInput) {
        this.alternativeInput = alternativeInput;
    }

    public void setTriggerData(Map<String, Object> data) throws IOException {
        this.triggerData = data;
    }

    public void setTriggerEvent(TriggerEvent event) throws IOException {
        this.setTriggerData(event.data());
    }

    public Map<String, Object> getTriggerData() {
        return this.triggerData;
    }

    public BytesReference getWatchSource() {
        return this.watchSource;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public void setWatchSource(BytesReference watchSource, XContentType xContentType) {
        this.watchSource = watchSource;
        this.xContentType = xContentType;
    }

    public void setWatchSource(WatchSourceBuilder watchSource) {
        this.watchSource = watchSource.buildAsBytes(XContentType.JSON);
        this.xContentType = XContentType.JSON;
    }

    public Map<String, ActionExecutionMode> getActionModes() {
        return this.actionModes;
    }

    public void setActionMode(String actionId, ActionExecutionMode actionMode) {
        this.actionModes.put(actionId, actionMode);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null && this.watchSource == null) {
            validationException = ValidateActions.addValidationError((String)"a watch execution request must either have a watch id or an inline watch source, but both are missing", validationException);
        }
        if (this.id != null && !WatcherUtils.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        for (String actionId : this.actionModes.keySet()) {
            if (actionId == null) {
                validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "action id may not be null", new Object[0]), (ActionRequestValidationException)validationException);
                continue;
            }
            if (WatcherUtils.isValidId(actionId)) continue;
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "action id [%s] contains whitespace", actionId), (ActionRequestValidationException)validationException);
        }
        if (this.watchSource != null && this.id != null) {
            validationException = ValidateActions.addValidationError((String)"a watch execution request must either have a watch id or an inline watch source but not both", (ActionRequestValidationException)validationException);
        }
        if (this.watchSource != null && this.recordExecution) {
            validationException = ValidateActions.addValidationError((String)"the execution of an inline watch cannot be recorded", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String toString() {
        return "execute[" + this.id + "]";
    }
}

