/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class CreateApiKeyRequest
extends ActionRequest {
    public static final WriteRequest.RefreshPolicy DEFAULT_REFRESH_POLICY = WriteRequest.RefreshPolicy.WAIT_UNTIL;
    private String name;
    private TimeValue expiration;
    private List<RoleDescriptor> roleDescriptors = Collections.emptyList();
    private WriteRequest.RefreshPolicy refreshPolicy = DEFAULT_REFRESH_POLICY;

    public CreateApiKeyRequest() {
    }

    public CreateApiKeyRequest(String name, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable TimeValue expiration) {
        this.name = name;
        this.roleDescriptors = roleDescriptors == null ? Collections.emptyList() : Collections.unmodifiableList(roleDescriptors);
        this.expiration = expiration;
    }

    public CreateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readOptionalString() : in.readString();
        this.expiration = in.readOptionalTimeValue();
        this.roleDescriptors = Collections.unmodifiableList(in.readList(RoleDescriptor::new));
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeValue getExpiration() {
        return this.expiration;
    }

    public void setExpiration(@Nullable TimeValue expiration) {
        this.expiration = expiration;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public void setRoleDescriptors(@Nullable List<RoleDescriptor> roleDescriptors) {
        this.roleDescriptors = roleDescriptors == null ? Collections.emptyList() : Collections.unmodifiableList(roleDescriptors);
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refresh policy may not be null");
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.name)) {
            validationException = ValidateActions.addValidationError((String)"api key name is required", validationException);
        } else {
            if (this.name.length() > 256) {
                validationException = ValidateActions.addValidationError((String)"api key name may not be more than 256 characters long", (ActionRequestValidationException)validationException);
            }
            if (!this.name.equals(this.name.trim())) {
                validationException = ValidateActions.addValidationError((String)"api key name may not begin or end with whitespace", (ActionRequestValidationException)validationException);
            }
            if (this.name.startsWith("_")) {
                validationException = ValidateActions.addValidationError((String)"api key name may not begin with an underscore", (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalString(this.name);
        } else {
            out.writeString(this.name);
        }
        out.writeOptionalTimeValue(this.expiration);
        out.writeList(this.roleDescriptors);
        this.refreshPolicy.writeTo(out);
    }
}

