/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SnapshotId;

public class SearchableSnapshotShardStats
implements Writeable,
ToXContentObject {
    private final List<CacheIndexInputStats> inputStats;
    private final ShardRouting shardRouting;
    private final SnapshotId snapshotId;
    private final IndexId indexId;

    public SearchableSnapshotShardStats(ShardRouting shardRouting, SnapshotId snapshotId, IndexId indexId, List<CacheIndexInputStats> stats) {
        this.shardRouting = Objects.requireNonNull(shardRouting);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indexId = Objects.requireNonNull(indexId);
        this.inputStats = Collections.unmodifiableList(Objects.requireNonNull(stats));
    }

    public SearchableSnapshotShardStats(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.snapshotId = new SnapshotId(in);
        this.indexId = new IndexId(in);
        this.inputStats = in.readList(CacheIndexInputStats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.snapshotId.writeTo(out);
        this.indexId.writeTo(out);
        out.writeList(this.inputStats);
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public List<CacheIndexInputStats> getStats() {
        return this.inputStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot_uuid", this.getSnapshotId().getUUID());
        builder.field("index_uuid", this.getIndexId().getId());
        builder.startObject("shard");
        builder.field("id", (ToXContent)this.shardRouting.shardId());
        builder.field("state", (Object)this.shardRouting.state());
        builder.field("primary", this.shardRouting.primary());
        builder.field("node", this.shardRouting.currentNodeId());
        if (this.shardRouting.relocatingNodeId() != null) {
            builder.field("relocating_node", this.shardRouting.relocatingNodeId());
        }
        builder.endObject();
        builder.startArray("files");
        List stats = this.inputStats.stream().sorted(Comparator.comparing(CacheIndexInputStats::getFileName)).collect(Collectors.toList());
        for (CacheIndexInputStats stat : stats) {
            stat.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SearchableSnapshotShardStats that = (SearchableSnapshotShardStats)other;
        return Objects.equals(this.shardRouting, that.shardRouting) && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.indexId, that.indexId) && Objects.equals(this.inputStats, that.inputStats);
    }

    public int hashCode() {
        return Objects.hash(this.shardRouting, this.snapshotId, this.indexId, this.inputStats);
    }

    public static class TimedCounter
    extends Counter {
        private final long totalNanoseconds;

        public TimedCounter(long count, long total, long min, long max, long totalNanoseconds) {
            super(count, total, min, max);
            this.totalNanoseconds = totalNanoseconds;
        }

        TimedCounter(StreamInput in) throws IOException {
            super(in);
            this.totalNanoseconds = in.readZLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.totalNanoseconds);
        }

        @Override
        void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (builder.humanReadable()) {
                builder.field("time", TimeValue.timeValueNanos((long)this.totalNanoseconds).toString());
            }
            builder.field("time_in_nanos", this.totalNanoseconds);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            TimedCounter that = (TimedCounter)other;
            return this.totalNanoseconds == that.totalNanoseconds;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.totalNanoseconds);
        }
    }

    public static class Counter
    implements Writeable,
    ToXContentObject {
        private final long count;
        private final long total;
        private final long min;
        private final long max;

        public Counter(long count, long total, long min, long max) {
            this.count = count;
            this.total = total;
            this.min = min;
            this.max = max;
        }

        Counter(StreamInput in) throws IOException {
            this.count = in.readZLong();
            this.total = in.readZLong();
            this.min = in.readZLong();
            this.max = in.readZLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.count);
            out.writeZLong(this.total);
            out.writeZLong(this.min);
            out.writeZLong(this.max);
        }

        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("count", this.count);
            builder.field("sum", this.total);
            builder.field("min", this.min);
            builder.field("max", this.max);
            this.innerToXContent(builder, params);
            builder.endObject();
            return builder;
        }

        void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        }

        public long getCount() {
            return this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Counter that = (Counter)other;
            return this.count == that.count && this.total == that.total && this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.total, this.min, this.max);
        }
    }

    public static class CacheIndexInputStats
    implements Writeable,
    ToXContentObject {
        private final String fileName;
        private final long fileLength;
        private final long openCount;
        private final long closeCount;
        private final Counter forwardSmallSeeks;
        private final Counter backwardSmallSeeks;
        private final Counter forwardLargeSeeks;
        private final Counter backwardLargeSeeks;
        private final Counter contiguousReads;
        private final Counter nonContiguousReads;
        private final Counter cachedBytesRead;
        private final Counter indexCacheBytesRead;
        private final TimedCounter cachedBytesWritten;
        private final TimedCounter directBytesRead;
        private final TimedCounter optimizedBytesRead;
        private final Counter blobStoreBytesRequested;
        private final long currentIndexCacheFills;

        public CacheIndexInputStats(String fileName, long fileLength, long openCount, long closeCount, Counter forwardSmallSeeks, Counter backwardSmallSeeks, Counter forwardLargeSeeks, Counter backwardLargeSeeks, Counter contiguousReads, Counter nonContiguousReads, Counter cachedBytesRead, Counter indexCacheBytesRead, TimedCounter cachedBytesWritten, TimedCounter directBytesRead, TimedCounter optimizedBytesRead, Counter blobStoreBytesRequested, long currentIndexCacheFills) {
            this.fileName = fileName;
            this.fileLength = fileLength;
            this.openCount = openCount;
            this.closeCount = closeCount;
            this.forwardSmallSeeks = forwardSmallSeeks;
            this.backwardSmallSeeks = backwardSmallSeeks;
            this.forwardLargeSeeks = forwardLargeSeeks;
            this.backwardLargeSeeks = backwardLargeSeeks;
            this.contiguousReads = contiguousReads;
            this.nonContiguousReads = nonContiguousReads;
            this.cachedBytesRead = cachedBytesRead;
            this.indexCacheBytesRead = indexCacheBytesRead;
            this.cachedBytesWritten = cachedBytesWritten;
            this.directBytesRead = directBytesRead;
            this.optimizedBytesRead = optimizedBytesRead;
            this.blobStoreBytesRequested = blobStoreBytesRequested;
            this.currentIndexCacheFills = currentIndexCacheFills;
        }

        CacheIndexInputStats(StreamInput in) throws IOException {
            this.fileName = in.readString();
            this.fileLength = in.readVLong();
            this.openCount = in.readVLong();
            this.closeCount = in.readVLong();
            this.forwardSmallSeeks = new Counter(in);
            this.backwardSmallSeeks = new Counter(in);
            this.forwardLargeSeeks = new Counter(in);
            this.backwardLargeSeeks = new Counter(in);
            this.contiguousReads = new Counter(in);
            this.nonContiguousReads = new Counter(in);
            this.cachedBytesRead = new Counter(in);
            this.indexCacheBytesRead = in.getVersion().onOrAfter(Version.V_7_10_0) ? new Counter(in) : new Counter(0L, 0L, 0L, 0L);
            this.cachedBytesWritten = new TimedCounter(in);
            this.directBytesRead = new TimedCounter(in);
            this.optimizedBytesRead = new TimedCounter(in);
            if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
                this.blobStoreBytesRequested = new Counter(in);
                this.currentIndexCacheFills = in.readVLong();
            } else {
                this.blobStoreBytesRequested = new Counter(0L, 0L, 0L, 0L);
                this.currentIndexCacheFills = 0L;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.fileName);
            out.writeVLong(this.fileLength);
            out.writeVLong(this.openCount);
            out.writeVLong(this.closeCount);
            this.forwardSmallSeeks.writeTo(out);
            this.backwardSmallSeeks.writeTo(out);
            this.forwardLargeSeeks.writeTo(out);
            this.backwardLargeSeeks.writeTo(out);
            this.contiguousReads.writeTo(out);
            this.nonContiguousReads.writeTo(out);
            this.cachedBytesRead.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
                this.indexCacheBytesRead.writeTo(out);
            }
            this.cachedBytesWritten.writeTo(out);
            this.directBytesRead.writeTo(out);
            this.optimizedBytesRead.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
                this.blobStoreBytesRequested.writeTo(out);
                out.writeVLong(this.currentIndexCacheFills);
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public long getOpenCount() {
            return this.openCount;
        }

        public long getCloseCount() {
            return this.closeCount;
        }

        public Counter getForwardSmallSeeks() {
            return this.forwardSmallSeeks;
        }

        public Counter getBackwardSmallSeeks() {
            return this.backwardSmallSeeks;
        }

        public Counter getForwardLargeSeeks() {
            return this.forwardLargeSeeks;
        }

        public Counter getBackwardLargeSeeks() {
            return this.backwardLargeSeeks;
        }

        public Counter getContiguousReads() {
            return this.contiguousReads;
        }

        public Counter getNonContiguousReads() {
            return this.nonContiguousReads;
        }

        public Counter getCachedBytesRead() {
            return this.cachedBytesRead;
        }

        public Counter getIndexCacheBytesRead() {
            return this.indexCacheBytesRead;
        }

        public TimedCounter getCachedBytesWritten() {
            return this.cachedBytesWritten;
        }

        public TimedCounter getDirectBytesRead() {
            return this.directBytesRead;
        }

        public TimedCounter getOptimizedBytesRead() {
            return this.optimizedBytesRead;
        }

        public Counter getBlobStoreBytesRequested() {
            return this.blobStoreBytesRequested;
        }

        public long getCurrentIndexCacheFills() {
            return this.currentIndexCacheFills;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.getFileName());
            builder.field("length", this.getFileLength());
            builder.field("open_count", this.getOpenCount());
            builder.field("close_count", this.getCloseCount());
            builder.field("contiguous_bytes_read", (ToXContent)this.getContiguousReads());
            builder.field("non_contiguous_bytes_read", (ToXContent)this.getNonContiguousReads());
            builder.field("cached_bytes_read", (ToXContent)this.getCachedBytesRead());
            builder.field("index_cache_bytes_read", (ToXContent)this.getIndexCacheBytesRead());
            builder.field("cached_bytes_written", (ToXContent)this.getCachedBytesWritten());
            builder.field("direct_bytes_read", (ToXContent)this.getDirectBytesRead());
            builder.field("optimized_bytes_read", (ToXContent)this.getOptimizedBytesRead());
            builder.startObject("forward_seeks");
            builder.field("small", (ToXContent)this.getForwardSmallSeeks());
            builder.field("large", (ToXContent)this.getForwardLargeSeeks());
            builder.endObject();
            builder.startObject("backward_seeks");
            builder.field("small", (ToXContent)this.getBackwardSmallSeeks());
            builder.field("large", (ToXContent)this.getBackwardLargeSeeks());
            builder.endObject();
            builder.field("blob_store_bytes_requested", (ToXContent)this.getBlobStoreBytesRequested());
            builder.field("current_index_cache_fills", this.getCurrentIndexCacheFills());
            return builder.endObject();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CacheIndexInputStats stats = (CacheIndexInputStats)other;
            return this.fileLength == stats.fileLength && this.openCount == stats.openCount && this.closeCount == stats.closeCount && Objects.equals(this.fileName, stats.fileName) && Objects.equals(this.forwardSmallSeeks, stats.forwardSmallSeeks) && Objects.equals(this.backwardSmallSeeks, stats.backwardSmallSeeks) && Objects.equals(this.forwardLargeSeeks, stats.forwardLargeSeeks) && Objects.equals(this.backwardLargeSeeks, stats.backwardLargeSeeks) && Objects.equals(this.contiguousReads, stats.contiguousReads) && Objects.equals(this.nonContiguousReads, stats.nonContiguousReads) && Objects.equals(this.cachedBytesRead, stats.cachedBytesRead) && Objects.equals(this.indexCacheBytesRead, stats.indexCacheBytesRead) && Objects.equals(this.cachedBytesWritten, stats.cachedBytesWritten) && Objects.equals(this.directBytesRead, stats.directBytesRead) && Objects.equals(this.optimizedBytesRead, stats.optimizedBytesRead) && Objects.equals(this.blobStoreBytesRequested, stats.blobStoreBytesRequested) && this.currentIndexCacheFills == stats.currentIndexCacheFills;
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.fileLength, this.openCount, this.closeCount, this.forwardSmallSeeks, this.backwardSmallSeeks, this.forwardLargeSeeks, this.backwardLargeSeeks, this.contiguousReads, this.nonContiguousReads, this.cachedBytesRead, this.indexCacheBytesRead, this.cachedBytesWritten, this.directBytesRead, this.optimizedBytesRead, this.blobStoreBytesRequested, this.currentIndexCacheFills);
        }
    }
}

