/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestRequest;

public class MountSearchableSnapshotRequest
extends MasterNodeRequest<MountSearchableSnapshotRequest> {
    public static final ConstructingObjectParser<MountSearchableSnapshotRequest, RestRequest> PARSER = new ConstructingObjectParser("mount_searchable_snapshot", true, (a, request) -> new MountSearchableSnapshotRequest((String)(a[1] != null ? a[1] : Objects.requireNonNull(a[0])), request.param("repository"), request.param("snapshot"), (String)a[0], (Settings)(a[2] != null ? a[2] : Settings.EMPTY), (String[])(a[3] != null ? a[3] : Strings.EMPTY_ARRAY), request.paramAsBoolean("wait_for_completion", false)));
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField RENAMED_INDEX_FIELD = new ParseField("renamed_index", new String[0]);
    private static final ParseField INDEX_SETTINGS_FIELD = new ParseField("index_settings", new String[0]);
    private static final ParseField IGNORE_INDEX_SETTINGS_FIELD = new ParseField("ignore_index_settings", new String[0]);
    private final String mountedIndexName;
    private final String repositoryName;
    private final String snapshotName;
    private final String snapshotIndexName;
    private final Settings indexSettings;
    private final String[] ignoredIndexSettings;
    private final boolean waitForCompletion;

    public MountSearchableSnapshotRequest(String mountedIndexName, String repositoryName, String snapshotName, String snapshotIndexName, Settings indexSettings, String[] ignoredIndexSettings, boolean waitForCompletion) {
        this.mountedIndexName = Objects.requireNonNull(mountedIndexName);
        this.repositoryName = Objects.requireNonNull(repositoryName);
        this.snapshotName = Objects.requireNonNull(snapshotName);
        this.snapshotIndexName = Objects.requireNonNull(snapshotIndexName);
        this.indexSettings = Objects.requireNonNull(indexSettings);
        this.ignoredIndexSettings = Objects.requireNonNull(ignoredIndexSettings);
        this.waitForCompletion = waitForCompletion;
    }

    public MountSearchableSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.mountedIndexName = in.readString();
        this.repositoryName = in.readString();
        this.snapshotName = in.readString();
        this.snapshotIndexName = in.readString();
        this.indexSettings = Settings.readSettingsFromStream((StreamInput)in);
        this.ignoredIndexSettings = in.readStringArray();
        this.waitForCompletion = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.mountedIndexName);
        out.writeString(this.repositoryName);
        out.writeString(this.snapshotName);
        out.writeString(this.snapshotIndexName);
        Settings.writeSettingsToStream((Settings)this.indexSettings, (StreamOutput)out);
        out.writeStringArray(this.ignoredIndexSettings);
        out.writeBoolean(this.waitForCompletion);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (IndexMetadata.INDEX_DATA_PATH_SETTING.exists(this.indexSettings)) {
            validationException = ValidateActions.addValidationError((String)"setting [index.data_path] is not permitted on searchable snapshots", validationException);
        }
        return validationException;
    }

    public String mountedIndexName() {
        return this.mountedIndexName;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String snapshotIndexName() {
        return this.snapshotIndexName;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public Settings indexSettings() {
        return this.indexSettings;
    }

    public String[] ignoreIndexSettings() {
        return this.ignoredIndexSettings;
    }

    public String getDescription() {
        return "mount snapshot [" + this.repositoryName + ":" + this.snapshotName + ":" + this.snapshotIndexName + "] as [" + this.mountedIndexName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MountSearchableSnapshotRequest that = (MountSearchableSnapshotRequest)((Object)o);
        return this.waitForCompletion == that.waitForCompletion && Objects.equals(this.mountedIndexName, that.mountedIndexName) && Objects.equals(this.repositoryName, that.repositoryName) && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.snapshotIndexName, that.snapshotIndexName) && Objects.equals(this.indexSettings, that.indexSettings) && Arrays.equals(this.ignoredIndexSettings, that.ignoredIndexSettings) && Objects.equals(this.masterNodeTimeout, that.masterNodeTimeout);
    }

    public int hashCode() {
        int result = Objects.hash(this.mountedIndexName, this.repositoryName, this.snapshotName, this.snapshotIndexName, this.indexSettings, this.waitForCompletion, this.masterNodeTimeout);
        result = 31 * result + Arrays.hashCode(this.ignoredIndexSettings);
        return result;
    }

    public String toString() {
        return this.getDescription();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), XContentParser::text, INDEX_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::text, RENAMED_INDEX_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), Settings::fromXContent, INDEX_SETTINGS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.list().stream().map(s -> (String)s).collect(Collectors.toList()).toArray(Strings.EMPTY_ARRAY), IGNORE_INDEX_SETTINGS_FIELD, ObjectParser.ValueType.STRING_ARRAY);
    }
}

