/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.search.action.OpenPointInTimeAction;
import org.elasticsearch.xpack.core.search.action.OpenPointInTimeRequest;

public class RestOpenPointInTimeAction
extends BaseRestHandler {
    public String getName() {
        return "open_point_in_time";
    }

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_pit"), new RestHandler.Route(RestRequest.Method.POST, "/_pit"));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        IndicesOptions indicesOptions = IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)OpenPointInTimeRequest.DEFAULT_INDICES_OPTIONS);
        String routing = request.param("routing");
        String preference = request.param("preference");
        TimeValue keepAlive = TimeValue.parseTimeValue((String)request.param("keep_alive"), null, (String)"keep_alive");
        OpenPointInTimeRequest openRequest = new OpenPointInTimeRequest(indices, indicesOptions, keepAlive, routing, preference);
        return channel -> client.execute((ActionType)OpenPointInTimeAction.INSTANCE, (ActionRequest)openRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

