/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.common;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class FoldValues
implements Writeable,
ToXContentObject {
    public static final ParseField FOLD = new ParseField("fold", new String[0]);
    public static final ParseField VALUES = new ParseField("values", new String[0]);
    private final int fold;
    private final double[] values;

    public static FoldValues fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return (FoldValues)FoldValues.createParser(ignoreUnknownFields).apply(parser, null);
    }

    private static ConstructingObjectParser<FoldValues, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("fold_values", ignoreUnknownFields, a -> new FoldValues((int)((Integer)a[0]), (List)a[1]));
        parser.declareInt(ConstructingObjectParser.constructorArg(), FOLD);
        parser.declareDoubleArray(ConstructingObjectParser.constructorArg(), VALUES);
        return parser;
    }

    private FoldValues(int fold, List<Double> values) {
        this(fold, values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    public FoldValues(int fold, double[] values) {
        this.fold = fold;
        this.values = values;
    }

    public FoldValues(StreamInput in) throws IOException {
        this.fold = in.readVInt();
        this.values = in.readDoubleArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.fold);
        out.writeDoubleArray(this.values);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FOLD.getPreferredName(), this.fold);
        builder.array(VALUES.getPreferredName(), this.values);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoldValues other = (FoldValues)o;
        return this.fold == other.fold && Arrays.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(this.fold, Arrays.hashCode(this.values));
    }
}

