/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

public class DataFrameAnalyticsSource
implements Writeable,
ToXContentObject {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField _SOURCE = new ParseField("_source", new String[0]);
    private final String[] index;
    private final QueryProvider queryProvider;
    private final FetchSourceContext sourceFiltering;

    public static ConstructingObjectParser<DataFrameAnalyticsSource, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("data_frame_analytics_source", ignoreUnknownFields, a -> new DataFrameAnalyticsSource(((List)a[0]).toArray(new String[0]), (QueryProvider)a[1], (FetchSourceContext)a[2]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryProvider.fromXContent(p, ignoreUnknownFields, "Data Frame Analytics config query is not parsable"), QUERY);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FetchSourceContext.fromXContent((XContentParser)p), _SOURCE, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        return parser;
    }

    public DataFrameAnalyticsSource(String[] index, @Nullable QueryProvider queryProvider, @Nullable FetchSourceContext sourceFiltering) {
        this.index = ExceptionsHelper.requireNonNull(index, INDEX);
        if (index.length == 0) {
            throw new IllegalArgumentException("source.index must specify at least one index");
        }
        if (Arrays.stream(index).anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("source.index must contain non-null and non-empty strings");
        }
        QueryProvider queryProvider2 = this.queryProvider = queryProvider == null ? QueryProvider.defaultQuery() : queryProvider;
        if (sourceFiltering != null && !sourceFiltering.fetchSource()) {
            throw new IllegalArgumentException("source._source cannot be disabled");
        }
        this.sourceFiltering = sourceFiltering;
    }

    public DataFrameAnalyticsSource(StreamInput in) throws IOException {
        this.index = in.readStringArray();
        this.queryProvider = QueryProvider.fromStream(in);
        this.sourceFiltering = in.getVersion().onOrAfter(Version.V_7_6_0) ? (FetchSourceContext)in.readOptionalWriteable(FetchSourceContext::new) : null;
    }

    public DataFrameAnalyticsSource(DataFrameAnalyticsSource other) {
        this.index = Arrays.copyOf(other.index, other.index.length);
        this.queryProvider = new QueryProvider(other.queryProvider);
        this.sourceFiltering = other.sourceFiltering == null ? null : new FetchSourceContext(other.sourceFiltering.fetchSource(), other.sourceFiltering.includes(), other.sourceFiltering.excludes());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.index);
        this.queryProvider.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeOptionalWriteable((Writeable)this.sourceFiltering);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(INDEX.getPreferredName(), this.index);
        builder.field(QUERY.getPreferredName(), this.queryProvider.getQuery());
        if (this.sourceFiltering != null) {
            builder.field(_SOURCE.getPreferredName(), (ToXContent)this.sourceFiltering);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsSource other = (DataFrameAnalyticsSource)o;
        return Arrays.equals(this.index, other.index) && Objects.equals(this.queryProvider, other.queryProvider) && Objects.equals(this.sourceFiltering, other.sourceFiltering);
    }

    public int hashCode() {
        return Objects.hash(Arrays.asList(this.index), this.queryProvider, this.sourceFiltering);
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryBuilder getParsedQuery() {
        Exception exception = this.queryProvider.getParsingException();
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new ElasticsearchException((Throwable)this.queryProvider.getParsingException());
        }
        return this.queryProvider.getParsedQuery();
    }

    public FetchSourceContext getSourceFiltering() {
        return this.sourceFiltering;
    }

    Exception getQueryParsingException() {
        return this.queryProvider.getParsingException();
    }

    QueryProvider getQueryProvider() {
        return this.queryProvider;
    }

    public List<String> getQueryDeprecations(NamedXContentRegistry namedXContentRegistry) {
        ArrayList<String> deprecations = new ArrayList<String>();
        try {
            XContentObjectTransformer.queryBuilderTransformer(namedXContentRegistry).fromMap(this.queryProvider.getQuery(), deprecations);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof IllegalArgumentException) {
                exception = (Exception)exception.getCause();
            }
            throw ExceptionsHelper.badRequestException("Data Frame Analytics config query is not parsable", exception, new Object[0]);
        }
        return deprecations;
    }

    Map<String, Object> getQuery() {
        return this.queryProvider.getQuery();
    }

    public boolean isFieldExcluded(String path) {
        if (this.sourceFiltering == null) {
            return false;
        }
        for (String exclude : this.sourceFiltering.excludes()) {
            if (!DataFrameAnalyticsSource.pathMatchesSourcePattern(path, exclude)) continue;
            return true;
        }
        if (this.sourceFiltering.includes().length == 0) {
            return false;
        }
        for (String include : this.sourceFiltering.includes()) {
            if (!DataFrameAnalyticsSource.pathMatchesSourcePattern(path, include)) continue;
            return false;
        }
        return true;
    }

    private static boolean pathMatchesSourcePattern(String path, String sourcePattern) {
        if (sourcePattern.equals(path)) {
            return true;
        }
        if (Regex.isSimpleMatchPattern((String)sourcePattern)) {
            return Regex.simpleMatch((String)sourcePattern, (String)path);
        }
        return Regex.simpleMatch((String)(sourcePattern + ".*"), (String)path);
    }
}

