/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetDatafeedsStatsAction
extends ActionType<Response> {
    public static final GetDatafeedsStatsAction INSTANCE = new GetDatafeedsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/datafeeds/stats/get";
    public static final String ALL = "_all";
    private static final String STATE = "state";
    private static final String NODE = "node";
    private static final String ASSIGNMENT_EXPLANATION = "assignment_explanation";
    private static final String TIMING_STATS = "timing_stats";

    private GetDatafeedsStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<DatafeedStats>
    implements ToXContentObject {
        public Response(QueryPage<DatafeedStats> datafeedsStats) {
            super(datafeedsStats);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public QueryPage<DatafeedStats> getResponse() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<DatafeedStats> getReader() {
            return DatafeedStats::new;
        }

        public static class DatafeedStats
        implements ToXContentObject,
        Writeable {
            private final String datafeedId;
            private final DatafeedState datafeedState;
            @Nullable
            private DiscoveryNode node;
            @Nullable
            private String assignmentExplanation;
            @Nullable
            private DatafeedTimingStats timingStats;

            public DatafeedStats(String datafeedId, DatafeedState datafeedState, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation, @Nullable DatafeedTimingStats timingStats) {
                this.datafeedId = Objects.requireNonNull(datafeedId);
                this.datafeedState = Objects.requireNonNull(datafeedState);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
                this.timingStats = timingStats;
            }

            DatafeedStats(StreamInput in) throws IOException {
                this.datafeedId = in.readString();
                this.datafeedState = DatafeedState.fromStream(in);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
                this.timingStats = in.getVersion().onOrAfter(Version.V_7_4_0) ? (DatafeedTimingStats)in.readOptionalWriteable(DatafeedTimingStats::new) : null;
            }

            public String getDatafeedId() {
                return this.datafeedId;
            }

            public DatafeedState getDatafeedState() {
                return this.datafeedState;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            public DatafeedTimingStats getTimingStats() {
                return this.timingStats;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
                builder.field(GetDatafeedsStatsAction.STATE, this.datafeedState.toString());
                if (this.node != null) {
                    builder.startObject(GetDatafeedsStatsAction.NODE);
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        if (!((String)entry.getKey()).startsWith("ml.")) continue;
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field(GetDatafeedsStatsAction.ASSIGNMENT_EXPLANATION, this.assignmentExplanation);
                }
                if (this.timingStats != null) {
                    builder.field(GetDatafeedsStatsAction.TIMING_STATS, (ToXContent)this.timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("include_calculated_fields", "true")));
                }
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.datafeedId);
                this.datafeedState.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
                if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
                    out.writeOptionalWriteable((Writeable)this.timingStats);
                }
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.datafeedId, this.datafeedState, this.node, this.assignmentExplanation, this.timingStats});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DatafeedStats other = (DatafeedStats)obj;
                return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals((Object)this.datafeedState, (Object)other.datafeedState) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation) && Objects.equals(this.timingStats, other.timingStats);
            }
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetDatafeedsStatsAction action) {
            super(client, (ActionType)action, (MasterNodeReadRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        @Deprecated
        public static final String ALLOW_NO_DATAFEEDS = "allow_no_datafeeds";
        public static final String ALLOW_NO_MATCH = "allow_no_match";
        private String datafeedId;
        private boolean allowNoMatch = true;

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoMatch = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoMatch);
            }
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
        }
    }
}

