/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.DataTier;
import org.elasticsearch.xpack.core.ilm.DataTierMigrationRoutedStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;

public class MigrateAction
implements LifecycleAction {
    public static final String NAME = "migrate";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    private static final List<String> COLD_TO_HOT_TIERS = org.elasticsearch.common.collect.List.of((Object[])new String[]{"data_cold", "data_warm", "data_hot"});
    private static final ConstructingObjectParser<MigrateAction, Void> PARSER = new ConstructingObjectParser("migrate", a -> new MigrateAction(a[0] == null ? true : (Boolean)a[0]));
    private final boolean enabled;

    public static MigrateAction parse(XContentParser parser) {
        return (MigrateAction)PARSER.apply(parser, null);
    }

    public MigrateAction() {
        this(true);
    }

    public MigrateAction(boolean enabled) {
        this.enabled = enabled;
    }

    public MigrateAction(StreamInput in) throws IOException {
        this(in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.enabled);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        if (this.enabled) {
            Step.StepKey migrationKey = new Step.StepKey(phase, NAME, NAME);
            Step.StepKey migrationRoutedKey = new Step.StepKey(phase, NAME, "check-migration");
            Settings.Builder migrationSettings = Settings.builder();
            String dataTierName = "data_" + phase;
            assert (DataTier.validTierName(dataTierName)) : "invalid data tier name:" + dataTierName;
            migrationSettings.put("index.routing.allocation.include._tier_preference", MigrateAction.getPreferredTiersConfiguration(dataTierName));
            UpdateSettingsStep updateMigrationSettingStep = new UpdateSettingsStep(migrationKey, migrationRoutedKey, client, migrationSettings.build());
            DataTierMigrationRoutedStep migrationRoutedStep = new DataTierMigrationRoutedStep(migrationRoutedKey, nextStepKey);
            return Arrays.asList(updateMigrationSettingStep, migrationRoutedStep);
        }
        return org.elasticsearch.common.collect.List.of();
    }

    static String getPreferredTiersConfiguration(String targetTier) {
        int indexOfTargetTier = COLD_TO_HOT_TIERS.indexOf(targetTier);
        if (indexOfTargetTier == -1) {
            throw new IllegalArgumentException("invalid data tier [" + targetTier + "]");
        }
        return COLD_TO_HOT_TIERS.stream().skip(indexOfTargetTier).collect(Collectors.joining(","));
    }

    public int hashCode() {
        return Objects.hash(this.enabled);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MigrateAction other = (MigrateAction)obj;
        return Objects.equals(this.enabled, other.enabled);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
    }
}

