/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;

public class LifecyclePolicyUtils {
    private LifecyclePolicyUtils() {
    }

    public static LifecyclePolicy loadPolicy(String name, String resource, NamedXContentRegistry xContentRegistry) {
        LifecyclePolicy lifecyclePolicy;
        block8: {
            BytesReference source = LifecyclePolicyUtils.load(resource);
            LifecyclePolicyUtils.validate(source);
            XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, LoggingDeprecationHandler.THROW_UNSUPPORTED_OPERATION, source.utf8ToString());
            try {
                lifecyclePolicy = LifecyclePolicy.parse(parser, name);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("unable to load policy [" + name + "] from [" + resource + "]", e);
                }
            }
            parser.close();
        }
        return lifecyclePolicy;
    }

    private static BytesReference load(String name) throws IOException {
        try (InputStream is = LifecyclePolicyUtils.class.getResourceAsStream(name);){
            BytesArray bytesArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Streams.copy((InputStream)is, (OutputStream)out);
                bytesArray = new BytesArray(out.toByteArray());
            }
            return bytesArray;
        }
    }

    private static void validate(BytesReference source) {
        if (source == null) {
            throw new ElasticsearchParseException("policy must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((BytesReference)source, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("policy must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("invalid policy", (Throwable)e, new Object[0]);
        }
    }
}

