/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class CopyExecutionStateStep
extends ClusterStateActionStep {
    public static final String NAME = "copy-execution-state";
    private static final Logger logger = LogManager.getLogger(CopyExecutionStateStep.class);
    private final String targetIndexPrefix;
    private final String targetNextStepName;

    public CopyExecutionStateStep(Step.StepKey key, Step.StepKey nextStepKey, String targetIndexPrefix, String targetNextStepName) {
        super(key, nextStepKey);
        this.targetIndexPrefix = targetIndexPrefix;
        this.targetNextStepName = targetNextStepName;
    }

    String getTargetIndexPrefix() {
        return this.targetIndexPrefix;
    }

    String getTargetNextStepName() {
        return this.targetNextStepName;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        String indexName = indexMetadata.getIndex().getName();
        String targetIndexName = this.targetIndexPrefix + indexName;
        IndexMetadata targetIndexMetadata = clusterState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            logger.warn("[{}] index [{}] unable to copy execution state to target index [{}] as target index does not exist", (Object)this.getKey().getAction(), (Object)index.getName(), (Object)targetIndexName);
            throw new IllegalStateException("unable to copy execution state from [" + index.getName() + "] to [" + targetIndexName + "] as target index does not exist");
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String phase = lifecycleState.getPhase();
        String action = lifecycleState.getAction();
        long lifecycleDate = lifecycleState.getLifecycleDate();
        LifecycleExecutionState.Builder relevantTargetCustomData = LifecycleExecutionState.builder();
        relevantTargetCustomData.setIndexCreationDate(lifecycleDate);
        relevantTargetCustomData.setPhase(phase);
        relevantTargetCustomData.setStep(this.targetNextStepName);
        if (this.targetNextStepName.equals("complete")) {
            relevantTargetCustomData.setAction("complete");
        } else {
            relevantTargetCustomData.setAction(action);
        }
        relevantTargetCustomData.setSnapshotRepository(lifecycleState.getSnapshotRepository());
        relevantTargetCustomData.setSnapshotName(lifecycleState.getSnapshotName());
        Metadata.Builder newMetadata = Metadata.builder((Metadata)clusterState.getMetadata()).put(IndexMetadata.builder((IndexMetadata)targetIndexMetadata).putCustom("ilm", relevantTargetCustomData.build().asMap()));
        return ClusterState.builder((ClusterState)clusterState).metadata(newMetadata).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopyExecutionStateStep that = (CopyExecutionStateStep)o;
        return Objects.equals(this.targetIndexPrefix, that.targetIndexPrefix) && Objects.equals(this.targetNextStepName, that.targetNextStepName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexPrefix, this.targetNextStepName);
    }
}

